-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
-- Mob: Diaboloss_Vestige
-- Note: Pet of Diabolos Umbra
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("dyna_2_0_diaboloss_vestige")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Vestige")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Vestige.onMobInitialize", function(mob)
    mob:setUntargetable(true)
    mob:setUnkillable(true)
    mob:setAutoAttackEnabled(false)
    mob:setMagicCastingEnabled(false)
    mob:addImmunity(xi.immunity.STUN)
    mob:addImmunity(xi.immunity.BLIND)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.POISON)
    mob:addImmunity(xi.immunity.PARALYZE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMobMod(xi.mobMod.DETECTION,  0x003)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Vestige.onMobFight", function(mob, target)
    mob:useMobAbility(1910) -- Nether Blast
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Vestige.onMobWeaponSkill", function(target, mob, skill)
    if skill:getID() == 1910 then
        mob:timer(3000, function(mobArg)
            DespawnMob(mobArg:getID())
        end)
    end
end)

return m
