-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
--  Mob: Diabolos Somnus
-- Note: Mega Boss
-- !spawnmob 16949326
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local music  = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_mobs")
-----------------------------------
local m = Module:new("dyna_2_0_diabolos_somnus")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setMobMod(xi.mobMod.NO_STANDBACK, 1)
    mob:setMobMod(xi.mobMod.DETECTION, 0x003)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.TERROR)
    mob:setMod(xi.mod.FIRE_MEVA, 25)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 25)
    mob:setMod(xi.mod.LIGHT_MEVA, 25)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 25)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 25)
    mob:setMod(xi.mod.LIGHT_SDT, 25)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.STUNRES, 60)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:setMod(xi.mod.MDEF, math.random(20, 30))
    mob:setMod(xi.mod.UDMGPHYS, -1500)
    mob:setMod(xi.mod.UDMGMAGIC, -1500)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 15)
    mob:addStatusEffect(xi.effect.REGAIN, 25, 3, 0)
    mob:addStatusEffect(xi.effect.REGEN, 15, 3, 0)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobSpawn", function(mob)
    local startWS = mob:getLocalVar("startWS")

    mob:setLocalVar("ruinousOmenHPP", math.random(35, 65))
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:addMod(xi.mod.ACC, 104)  -- 500 total acc
    mob:addMod(xi.mod.ATT, 38) -- 500 total atk
    mob:addMod(xi.mod.DEF, 95)  -- 500 total def
    mob:addMod(xi.mod.EVA, 11)  -- 420 total eva
    mob:addMod(xi.mod.CHR, 7)
    mob:addMod(xi.mod.MND, 63)
    mob:addMod(xi.mod.STR, 22)
    mob:addMod(xi.mod.VIT, 22)

    mob:addListener("ENGAGE", "openWS", function(mobArg) -- open each fight immediately with noctoshield
        mobArg:useMobAbility(1905) -- noctoshield
        mobArg:setLocalVar("startWS", 1)
    end)

    if startWS == 1 then
        mob:removeListener("openWS")
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobFight", function(mob, target)
    local lifePercent     = mob:getHPP()
    local act             = mob:getCurrentAction()
    local isBusy          = false
    local ruinousOmenHPP  = mob:getLocalVar("ruinousOmenHPP")
    local ruinousOmenUsed = mob:getLocalVar("ruinousOmenUsed")

    if act == xi.act.MOBABILITY_START
       or act == xi.act.MOBABILITY_USING
       or act == xi.act.MOBABILITY_FINISH
       or act == xi.act.MAGIC_CASTING
       or act == xi.act.MAGIC_START
       or act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function canPerformAction(mobArg)
        return mobArg:isAlive() and mobArg:actionQueueEmpty() and not isBusy
    end

    local function monsterSpecial(mobArg)
        mobArg:useMobAbility(624) -- dust cloud
        mobArg:useMobAbility(1911) -- ruinous omen
        mobArg:setLocalVar("ruinousOmenUsed", 1)
    end

    if canPerformAction(mob) then
        if lifePercent <= ruinousOmenHPP and ruinousOmenUsed == 0 then
            monsterSpecial(mob)
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobWeaponSkillPrepare", function(mob, target)
    if math.random() <= 0.5 then
        return 1918 -- nether tempest
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("openWS")
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Somnus.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
    player:addTitle(xi.title.NIGHTMARE_ILLUMINATOR)
    music.setWinMusic(player)
end)

return m
