-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
-- Mob: Diabolos's Shard
-- Note: Pet of Diabolos Club
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("dyna_2_0_diaboloss_shard")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobInitialize", function(mob)
    mob:setUntargetable(true)
    mob:setUnkillable(true)
    mob:setAutoAttackEnabled(false)
    mob:setMagicCastingEnabled(false)
    mob:addImmunity(xi.immunity.STUN)
    mob:addImmunity(xi.immunity.BLIND)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.POISON)
    mob:addImmunity(xi.immunity.PARALYZE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobSpawn", function(mob)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobFight", function(mob, target)
    mob:useMobAbility(1903)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobWeaponSkill", function(target, mob, skill)
    if skill:getID() == 1903 then
        DespawnMob(mob:getID())
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobDespawn", function(mob)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diaboloss_Shard.onMobDeath", function(mob, player, optParams)
end)

return m
