-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
--  Mob: Diabolos Nox
-- Note: Mega Boss
-- !spawnmob 16949327
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local music  = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_mobs")
-----------------------------------
local m = Module:new("dyna_2_0_diabolos_nox")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setMobMod(xi.mobMod.NO_STANDBACK, 1)
    mob:setMobMod(xi.mobMod.DETECTION, 0x003)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.TERROR)
    mob:setMod(xi.mod.FIRE_MEVA, 25)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 25)
    mob:setMod(xi.mod.LIGHT_MEVA, 25)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 25)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 25)
    mob:setMod(xi.mod.LIGHT_SDT, 25)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.STUNRES, 60)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:setMod(xi.mod.MDEF, math.random(20, 30))
    mob:setMod(xi.mod.UFASTCAST, 50)
    mob:setMod(xi.mod.UDMGPHYS, -1500)
    mob:setMod(xi.mod.UDMGMAGIC, -1500)
    mob:setMod(xi.mod.SPELLINTERRUPT, 65)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REGEN, 15, 3, 0)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobSpawn", function(mob)
    local currentTime = os.time()

    mob:setLocalVar("ruinousOmenHPP", math.random(35, 65))
    mob:setLocalVar("deathRecast", currentTime + math.random(60, 120)) -- 1 - 2 mins before first death spell
    mob:setLocalVar("kaustraRecast", currentTime + math.random(60, 120)) -- 1 - 2 mins before first kaustra spell
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:addMod(xi.mod.ACC, 104)  -- 500 total acc
    mob:addMod(xi.mod.ATT, 38) -- 500 total atk
    mob:addMod(xi.mod.DEF, 95)  -- 500 total def
    mob:addMod(xi.mod.EVA, 11)  -- 420 total eva
    mob:addMod(xi.mod.CHR, 7)
    mob:addMod(xi.mod.MND, 63)
    mob:addMod(xi.mod.STR, 22)
    mob:addMod(xi.mod.VIT, 22)
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.CHAINSPELL, hpp = math.random(6, 12)},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobFight", function(mob, target)
    local lifePercent     = mob:getHPP()
    local currentTime     = os.time()
    local act             = mob:getCurrentAction()
    local isBusy          = false
    local deathRecast     = mob:getLocalVar("deathRecast")
    local kaustraRecast   = mob:getLocalVar("kaustraRecast")
    local ruinousOmenHPP  = mob:getLocalVar("ruinousOmenHPP")
    local ruinousOmenUsed = mob:getLocalVar("ruinousOmenUsed")

    if act == xi.act.MOBABILITY_START
       or act == xi.act.MOBABILITY_USING
       or act == xi.act.MOBABILITY_FINISH
       or act == xi.act.MAGIC_CASTING
       or act == xi.act.MAGIC_START
       or act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function canPerformAction(mobArg)
        return mobArg:isAlive() and mobArg:actionQueueEmpty() and not isBusy
    end

    local function monsterSpecial(mobArg)
        mobArg:useMobAbility(624) -- dust cloud
        mobArg:useMobAbility(1911) -- ruinous omen
        mobArg:setLocalVar("ruinousOmenUsed", 1)
    end

    if canPerformAction(mob) then
        if lifePercent <= ruinousOmenHPP and ruinousOmenUsed == 0 then
            monsterSpecial(mob)
        end

        if currentTime > deathRecast then
            mob:castSpell(367, target) -- death spell
            mob:setLocalVar("deathRecast", currentTime + math.random(120, 180)) -- 2 - 3 mins
        end

        if currentTime > kaustraRecast then
            mob:castSpell(502, target) -- kaustra
            mob:setLocalVar("kaustraRecast", currentTime + math.random(60, 120)) -- 1 - 2 mins
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobMagicPrepare", function(mob, target, spellID)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(15, 30))
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onSpellPrecast", function(mob, spell)
    local kaustraSpellId = 502

    if spell:getID() == kaustraSpellId then
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(10)
        spell:setMPCost(1)
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Nox.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
    player:addTitle(xi.title.NIGHTMARE_ILLUMINATOR)
    music.setWinMusic(player)
end)

return m
