-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
--  Mob: Diabolos Letum
-- Note: Mega Boss
-- !spawnmob 16949328
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local music  = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_mobs")
-----------------------------------
local m = Module:new("dyna_2_0_diabolos_letum")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:setMobMod(xi.mobMod.NO_STANDBACK, 1)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setMobMod(xi.mobMod.DETECTION, 0x003)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.TERROR)
    mob:setMod(xi.mod.FIRE_MEVA, 25)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 25)
    mob:setMod(xi.mod.LIGHT_MEVA, 25)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 25)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 25)
    mob:setMod(xi.mod.LIGHT_SDT, 25)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.STUNRES, 60)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:setMod(xi.mod.MDEF, math.random(20, 30))
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMod(xi.mod.SPELLINTERRUPT, 65)
    mob:setMod(xi.mod.REGAIN, 30)
    mob:addStatusEffect(xi.effect.REGEN, 50, 3, 0)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobSpawn", function(mob)
    local startWS     = mob:getLocalVar("startWS")
    local currentTime = os.time()

    mob:setLocalVar("ruinousOmenHPP", math.random(35, 65))
    mob:setLocalVar("spellCasting", currentTime + math.random(8, 15))
    mob:setLocalVar("magicCastingEnabled", 1)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:setLocalVar("deathRecast", currentTime + math.random(60, 120)) -- 1 - 2 mins before first death spell
    mob:setMagicCastingEnabled(false)
    mob:setAutoAttackEnabled(false)
    mob:addMod(xi.mod.ACC, 104)  -- 500 total acc
    mob:addMod(xi.mod.ATT, 38) -- 500 total atk
    mob:addMod(xi.mod.DEF, 95)  -- 500 total def
    mob:addMod(xi.mod.EVA, 11)  -- 420 total eva
    mob:addMod(xi.mod.CHR, 7)
    mob:addMod(xi.mod.MND, 63)
    mob:addMod(xi.mod.STR, 22)
    mob:addMod(xi.mod.VIT, 22)

    mob:addListener("ENGAGE", "openWS", function(mobArg) -- open each fight immediately with cacodemonia
        mobArg:useMobAbility(1909) -- cacodemonia
        mobArg:setLocalVar("startWS", 1)
    end)

    mob:addListener("WEAPONSKILL_STATE_EXIT", "bonusWS", function(mobArg, skillID)
        local nightmareSkill = 1908
        local daydreamSkill  = 1919
        local repeatSkill = math.random() < 0.5  -- 50% chance

        if skillID == nightmareSkill then
            mobArg:timer(3000, function(mobArgTwo)
                mobArgTwo:useMobAbility(daydreamSkill)
            end)
        end

        if skillID == daydreamSkill and repeatSkill then
            mobArg:timer(3000, function(mobArgTwo)
                mobArgTwo:useMobAbility(daydreamSkill)
            end)
        end
    end)

    mob:addListener('MAGIC_USE', 'nightmarePowerUp', function(mobArg, spell)
        local nightmareTrigger = mobArg:getLocalVar("nightmareTrigger")

        if mobArg == nil then
            return
        end

        if mobArg:isAlive() then
            local increment = math.random(2, 5) -- we can adjust this value for balance.

            mobArg:setLocalVar("nightmareTrigger", nightmareTrigger + increment)
        end
    end)

    if startWS == 1 then
        mob:removeListener("openWS")
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobFight", function(mob, target)
    local lifePercent         = mob:getHPP()
    local act                 = mob:getCurrentAction()
    local isBusy              = false
    local currentTime         = os.time()
    local nightmareTrigger    = mob:getLocalVar("nightmareTrigger")
    local ruinousOmenHPP      = mob:getLocalVar("ruinousOmenHPP")
    local ruinousOmenUsed     = mob:getLocalVar("ruinousOmenUsed")
    local spellCasting        = mob:getLocalVar("spellCasting")
    local magicCastingEnabled = mob:getLocalVar("magicCastingEnabled")
    local deathRecast         = mob:getLocalVar("deathRecast")

    if act == xi.act.MOBABILITY_START
       or act == xi.act.MOBABILITY_USING
       or act == xi.act.MOBABILITY_FINISH
       or act == xi.act.MAGIC_CASTING
       or act == xi.act.MAGIC_START
       or act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function canPerformAction(mobArg)
        return mobArg:isAlive() and mobArg:actionQueueEmpty() and not isBusy
    end

    local function monsterSpecial(mobArg)
        mobArg:useMobAbility(624) -- dust cloud
        mobArg:useMobAbility(1911) -- ruinous omen
        mobArg:setLocalVar("ruinousOmenUsed", 1)
        mobArg:setMod(xi.mod.REGAIN, 25)
    end

    local function nightmareSpecial(mobArg)
        mobArg:useMobAbility(1908) -- nightmare
        mobArg:setLocalVar("nightmareTrigger", 0)
    end

    if canPerformAction(mob) then
        if lifePercent <= ruinousOmenHPP and ruinousOmenUsed == 0 then
            monsterSpecial(mob)
        end

        if currentTime >= spellCasting and magicCastingEnabled == 1 then
            mob:setMagicCastingEnabled(true)
            mob:setLocalVar("magicCastingEnabled", 2)
        end

        if currentTime > deathRecast then
            mob:castSpell(367, target) -- death spell
            mob:setLocalVar("deathRecast", currentTime + math.random(120, 180)) -- 2 - 3 mins
        end

        if nightmareTrigger >= 11 then
            nightmareSpecial(mob)
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobMagicPrepare", function(mob, target, spellID)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(15, 25))
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onSpellPrecast", function(mob, spell)
    local drainID = 245 -- Drain
    if spell:getID() == drainID then
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL) -- Drainga
        spell:setRadius(20)
        spell:setMPCost(1)
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("openWS")
    mob:removeListener("bonusWS")
    mob:removeListener("nightmarePowerUp")
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Letum.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
    player:addTitle(xi.title.NIGHTMARE_ILLUMINATOR)
    music.setWinMusic(player)
end)

return m
