-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis-Tavnazia
--  Mob: Diabolos Heart
-- Note: Mega Boss
-- !spawnmob 16949250
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local music  = require("modules/catseyexi/lua/additive_overrides/systems/dynamis_2_0/neo_dyna_mobs")
-----------------------------------
local m = Module:new("dyna_2_0_diabolos_heart")

xi.module.ensureTable("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart")

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setMobMod(xi.mobMod.NO_STANDBACK, 1)
    mob:setMobMod(xi.mobMod.DETECTION, 0x003)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.TERROR)
    mob:setMod(xi.mod.FIRE_MEVA, 25)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 25)
    mob:setMod(xi.mod.LIGHT_MEVA, 25)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 25)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 25)
    mob:setMod(xi.mod.LIGHT_SDT, 25)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:setMod(xi.mod.MDEF, math.random(20, 30))
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMod(xi.mod.SPELLINTERRUPT, 65)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart.onMobSpawn", function(mob)
    mob:setLocalVar("ruinousOmenHPP", math.random(35, 65))
    mob:setLocalVar("deathRecast", os.time() + math.random(60, 120)) -- 1 - 2 mins before first death spell
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:addMod(xi.mod.ACC, 57)  -- 400 total acc
    mob:addMod(xi.mod.ATT, 20) -- 425 total atk
    mob:addMod(xi.mod.DEF, 62)  -- 425 total def
    mob:addMod(xi.mod.EVA, 11)  -- 375 total eva
    mob:addMod(xi.mod.STR, 18)
    mob:addMod(xi.mod.DEX, 5)
    mob:addMod(xi.mod.VIT, 18)
    mob:addMod(xi.mod.MND, 56)
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart.onMobFight", function(mob, target)
    local lifePercent     = mob:getHPP()
    local currentTime     = os.time()
    local act             = mob:getCurrentAction()
    local isBusy          = false
    local deathRecast     = mob:getLocalVar("deathRecast")
    local ruinousOmenHPP  = mob:getLocalVar("ruinousOmenHPP")
    local ruinousOmenUsed = mob:getLocalVar("ruinousOmenUsed")

    if act == xi.act.MOBABILITY_START
       or act == xi.act.MOBABILITY_USING
       or act == xi.act.MOBABILITY_FINISH
       or act == xi.act.MAGIC_CASTING
       or act == xi.act.MAGIC_START
       or act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function canPerformAction(mobArg)
        return mobArg:isAlive() and mobArg:actionQueueEmpty() and not isBusy
    end

    local function monsterSpecial(mobArg)
        mobArg:useMobAbility(624) -- dust cloud
        mobArg:useMobAbility(1911) -- ruinous omen
        mobArg:setLocalVar("ruinousOmenUsed", 1)
    end

    if canPerformAction(mob) then
        if lifePercent <= ruinousOmenHPP and ruinousOmenUsed == 0 then
            monsterSpecial(mob)
        end

        if currentTime > deathRecast then
            mob:castSpell(367, target) -- death spell
            mob:setLocalVar("deathRecast", currentTime + math.random(120, 180)) -- 2 - 3 mins
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Club.onMobMagicPrepare", function(mob, target, spellId)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(20, 35))
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Dynamis-Tavnazia.mobs.Diabolos_Heart.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
    player:addTitle(xi.title.NIGHTMARE_AWAKENER)
    music.setWinMusic(player)
end)

return m
