-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - San d'Oria
-- Mob: Steelshank Kratzvatz
-- !Spawnmob 17535208
-- !pos 14.7472 2.2000 -93.4337 185
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_steelshank_kratzvatz")

xi.module.ensureTable("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz")

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
    mob:setSpellList(977)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onMobSpawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, -22) -- 425 total atk
    mob:addMod(xi.mod.DEF, 23) -- 475 total def
    mob:addMod(xi.mod.EVA, 49)-- 375 total eva
    pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
    SpawnMob(pet:getID())
    pet:updateEnmity(mob:getTarget())
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.INVINCIBLE, cooldown = math.random(90, 120), hpp = math.random(92, 98)},
            {id = xi.jsa.FAMILIAR, hpp = 95},
            {id = xi.jsa.FAMILIAR, hpp = 75},
            {id = xi.jsa.FAMILIAR, hpp = 50},
            {id = xi.jsa.FAMILIAR, hpp = 25},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onMobFight", function(mob, target)
    local invincible  = mob:getLocalVar("invincible")
    local divine      = mob:getLocalVar("divine")
    local pet         = GetMobByID(mob:getID() + 1)
    local lifePercent = mob:getHPP()
    local bstSP       = mob:getLocalVar("bstSP")

    local function buffPet(mob)
        pet:setHP(pet:getMaxHP())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("bstSP", mob:getLocalVar("bstSP") + 1)
    end

    local function callPet(mob)
        pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
        SpawnMob(pet:getID())
        pet:updateEnmity(mob:getTarget())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("bstSP", mob:getLocalVar("bstSP") + 1)
    end
    -- check for pet before bst SP, spawn if needed and buff.
    if lifePercent < 97 and pet:isAlive() and bstSP == 0 then
        buffPet(mob)
    elseif lifePercent < 97 and pet:isDead() and bstSP == 0 then
        callPet(mob)
    elseif lifePercent < 77 and pet:isAlive() and bstSP == 1 then
        buffPet(mob)
    elseif lifePercent < 77 and pet:isDead() and bstSP == 1 then
        callPet(mob)
    elseif lifePercent < 52 and pet:isAlive() and bstSP == 2 then
        buffPet(mob)
    elseif lifePercent < 52 and pet:isDead() and bstSP == 2 then
        callPet(mob)
    elseif lifePercent < 27 and pet:isAlive() and bstSP == 3 then
        buffPet(mob)
    elseif lifePercent < 27 and pet:isDead() and bstSP == 3 then
        callPet(mob)
    end

    mob:addListener("EFFECT_GAIN", "shieldStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.INVINCIBLE then
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 20)
            mob:addStatusEffect(xi.effect.DIVINE_SEAL, 1, 0, 0)
            mob:setLocalVar("invincible", 1)
            mob:setSpellList(976)
        end
    end)

    mob:addListener("EFFECT_LOSE", "cureBonus", function(mob, effect)
        if effect:getEffectType() == xi.effect.DIVINE_SEAL then
            mob:setLocalVar("divine", 0)
        end
    end)

    if invincible == 1 and divine == 0 then
        mob:addStatusEffect(xi.effect.DIVINE_SEAL, 1, 0, 0)
        mob:setLocalVar("divine", 1)
    end

    mob:addListener("EFFECT_LOSE", "shieldEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.INVINCIBLE then
            mob:setLocalVar("invincible", 0)
            mob:delStatusEffect(xi.effect.DIVINE_SEAL)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
            mob:setSpellList(977)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onMobDespawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("shieldStart")
    mob:removeListener("shieldEnd")
    mob:removeListener("cureBonus")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Steelshank_Kratzvatz.onMobDeath", function(mob, player, optParams)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("shieldStart")
    mob:removeListener("shieldEnd")
    mob:removeListener("cureBonus")
    mob:removeListener("shortProc")
end)

return m
