----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - San d'Oria
-- Mob: Spellspear Djokvukk
-- !Spawnmob 17535211
-- !pos 185
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_spellspear_djokvukk")

xi.module.ensureTable("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk")

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setSpellList(973)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onMobSpawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 4) -- 400 total acc
    mob:addMod(xi.mod.ATT, -7) -- 450 total atk
    mob:addMod(xi.mod.DEF, 40) -- 425 total def
    mob:addMod(xi.mod.EVA, 39)-- 375 total eva
    pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
    SpawnMob(pet:getID())
    pet:updateEnmity(mob:getTarget())
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.CHAINSPELL, cooldown = math.random(90, 120), hpp = math.random(92, 98)},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onMobFight", function(mob, target)
    local pet = GetMobByID(mob:getID() + 1)
    local lifePercent = mob:getHPP()
    local drgSP = mob:getLocalVar("drgSP")

    local function buffPet(mob)
        pet:setHP(pet:getMaxHP())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("drgSP", mob:getLocalVar("drgSP") + 1)
    end

    local function callPet(mob)
        pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
        SpawnMob(pet:getID())
        pet:updateEnmity(mob:getTarget())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("drgSP", mob:getLocalVar("drgSP") + 1)
    end

    if lifePercent < 81 and pet:isAlive() and drgSP == 0 then
        buffPet(mob)
    elseif lifePercent < 81 and pet:isDead() and drgSP == 0 then
        callPet(mob)
    elseif lifePercent < 61 and pet:isAlive() and drgSP == 1 then
        buffPet(mob)
    elseif lifePercent < 61 and pet:isDead() and drgSP == 1 then
        callPet(mob)
    elseif lifePercent < 41 and pet:isAlive() and drgSP == 2 then
        buffPet(mob)
    elseif lifePercent < 41 and pet:isDead() and drgSP == 2 then
        callPet(mob)
    elseif lifePercent < 21 and pet:isAlive() and drgSP == 3 then
        buffPet(mob)
    elseif lifePercent < 21 and pet:isDead() and drgSP == 3 then
        callPet(mob)
    end

    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            if math.random(1, 2) > 1 then
                mob:setSpellList(972) -- nukes
            else
                mob:setSpellList(971) -- buffs
            end
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(973) -- enfeebles
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onMobDespawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Spellspear_Djokvukk.onMobDeath", function(mob, player, optParams)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("shortProc")
end)

return m
