-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - San d'Oria
-- Mob: Bladeburner Rokgevok
-- !Spawnmob 17535207
-- !pos 100.3206 1.0000 -47.8884 185
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_bladeburner_rokgevok")

xi.module.ensureTable("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok")

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 20)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -48) -- 425 total atk
    mob:addMod(xi.mod.DEF, 61)  -- 475 total def
    mob:addMod(xi.mod.EVA, 34)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(90, 120),
        specials =
        {
            {id = xi.jsa.MANAFONT, hpp = math.random(92, 98), cooldown = 0},
            {id = xi.jsa.MIGHTY_STRIKES, hpp = math.random(82, 88), cooldown = 0},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onMobFight", function(mob, target)

    mob:addListener("EFFECT_GAIN", "warStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:setMagicCastingEnabled(false)
            mob:setMod(xi.mod.DOUBLE_ATTACK, 30) -- gains ten DA here
            mob:addStatusEffect(xi.effect.RETALIATION, 1, 0, 0)
            mob:addStatusEffect(xi.effect.BLOOD_RAGE, 1, 0, 0)
        end
    end)

    mob:addListener("EFFECT_LOSE", "warEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:setMagicCastingEnabled(true)
            mob:setMod(xi.mod.DOUBLE_ATTACK, 20) -- defaulted
            mob:delStatusEffect(xi.effect.RETALIATION)
            mob:delStatusEffect(xi.effect.BLOOD_RAGE)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onSpellPrecast", function(mob, spell)
    if spell:getID() == 273 or -- sleepga
        spell:getID() == 274 -- sleepga ii
    then
        mob:addStatusEffect(xi.effect.ELEMENTAL_SEAL, 1, 0, 0)
    end
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onMobDespawn", function(mob)
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-San_dOria.mobs.Bladeburner_Rokgevok.onMobDeath", function(mob, player, optParams)
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
    mob:removeListener("shortProc")
end)

return m
