-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Qufim
--  Mob: Lost Suttung
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_lost_suttung")

xi.module.ensureTable("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung")

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 90)
    mob:setMod(xi.mod.ICE_MEVA, 90)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 90)
    mob:setMod(xi.mod.THUNDER_MEVA, 90)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 90)
    mob:setMod(xi.mod.ICE_SDT, 90)
    mob:setMod(xi.mod.WIND_SDT, 90)
    mob:setMod(xi.mod.EARTH_SDT, 90)
    mob:setMod(xi.mod.THUNDER_SDT, 90)
    mob:setMod(xi.mod.WATER_SDT, 90)
    mob:setMod(xi.mod.LIGHT_SDT, 90)
    mob:setMod(xi.mod.DARK_SDT, 90)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 15)
    mob:addMod(xi.mod.MATT, 200)
    mob:setMod(xi.mod.STORETP, -10)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:setMod(xi.mod.UDMGPHYS, -5000)
    mob:setMod(xi.mod.UDMGRANGE, -5000)
    mob:setMod(xi.mod.UDMGMAGIC, -5000)
    mob:setMod(xi.mod.UDMGBREATH, -5000)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung.onMobFight", function(mob, target)
    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Lost_Suttung.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

return m
