-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Qufim
-- Mob: Arch Antaeus
-- Note: This monster has unique interactions with itemIDs 5903, 5904, 5905.
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_arch_antaeus")

xi.module.ensureTable("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus")

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 90)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 90)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 100)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 100)
    mob:setMod(xi.mod.EARTH_SDT, 100)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 100)
    mob:setMod(xi.mod.LIGHT_SDT, 100)
    mob:setMod(xi.mod.DARK_SDT, 100)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 20)
    mob:addMod(xi.mod.ATT, 300)
    mob:addMod(xi.mod.MATT, 100)
    mob:setMod(xi.mod.CRITHITRATE, 100)
    mob:setMod(xi.mod.UDMGPHYS, -7500)
    mob:setMod(xi.mod.UDMGRANGE, -7500)
    mob:setMod(xi.mod.UDMGMAGIC, -7500)
    mob:setMod(xi.mod.UDMGBREATH, -7500)
    mob:setMod(xi.mod.REGEN, 500)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes

    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.EES_GIGA, cooldown = math.random(90, 120), hpp = math.random(89, 96)}
        },
    })

    mob:addListener("EFFECT_GAIN", "venomUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.STR_BOOST then
            mobArg:weaknessTrigger(1)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("venom", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "wingUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.DEX_BOOST then
            mobArg:weaknessTrigger(2)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("wing", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "moietyUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.VIT_BOOST then
            mobArg:weaknessTrigger(3)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("moiety", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobFight", function(mob, target)
    local venom = mob:getLocalVar("venom")
    local wing = mob:getLocalVar("wing")
    local moiety = mob:getLocalVar("moiety")

    if venom == 1 then
        mob:removeListener("venomUSE")
        mob:setMod(xi.mod.REGEN, 0)
        mob:setLocalVar("venom", 2)
    end

    if wing == 1 then
        mob:removeListener("wingUSE")
        mob:setMod(xi.mod.CRITHITRATE, -100)
        mob:delMod(xi.mod.ATT, 150)
        mob:setLocalVar("wing", 2)
    end

    if moiety == 1 then
        mob:removeListener("moietyUSE")
        mob:setMod(xi.mod.UDMGPHYS, 0)
        mob:setMod(xi.mod.UDMGRANGE, 0)
        mob:setMod(xi.mod.UDMGMAGIC, 0)
        mob:setMod(xi.mod.UDMGBREATH, 0)
        mob:setLocalVar("moiety", 2)
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 5000
    })
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobWeaponSkillPrepare", function(mob, target)
    local random = math.random()
    if random <= 0.25 then
        return 662 -- Lightning Roar
    elseif random <= 0.50 then
        return 664 -- Impact Roar
    elseif random <= 0.75 then
        return 665 -- Grand Slam
    else
        return 667 -- Power Attack Weapon
    end
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("venomUSE")
    mob:removeListener("wingUSE")
    mob:removeListener("moietyUSE")
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Arch_Antaeus.onMobDeath", function(mob, player, optParams)
end)

return m
