-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Qufim
-- Mob: Antaeus
-- Note: This monster has unique interactions with itemIDs 5903, 5904, 5905.
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_antaeus")

xi.module.ensureTable("xi.zones.Dynamis-Qufim.mobs.Antaeus")

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 15)
    mob:addMod(xi.mod.ATT, 100)
    mob:setMod(xi.mod.CRITHITRATE, 50)
    mob:setMod(xi.mod.UDMGPHYS, -5000)
    mob:setMod(xi.mod.UDMGRANGE, -5000)
    mob:setMod(xi.mod.UDMGMAGIC, -5000)
    mob:setMod(xi.mod.UDMGBREATH, -5000)
    mob:setMod(xi.mod.REGEN, 250)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobSpawn", function(mob)
   mob:setLocalVar("[rage]timer", 900) -- 15 minutes

    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            { id = xi.jsa.EES_GIGA, hpp = 50, cooldown = math.random(90, 120) },
        },
    })

    mob:addListener("EFFECT_GAIN", "venomUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.STR_BOOST then
            mobArg:weaknessTrigger(1)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("venom", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "wingUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.DEX_BOOST then
            mobArg:weaknessTrigger(2)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("wing", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "moietyUSE", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.VIT_BOOST then
            mobArg:weaknessTrigger(3)
            mobArg:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mobArg:setLocalVar("moiety", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobFight", function(mob, target)
    local venom = mob:getLocalVar("venom")
    local wing = mob:getLocalVar("wing")
    local moiety = mob:getLocalVar("moiety")
    local distance = mob:checkDistance(target)
    local trebuchetTime = mob:getLocalVar("trebuchetTime")
    local isBusy = false
    local act = mob:getCurrentAction()

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_CASTING
    then
        isBusy = true
    end

    if mob:actionQueueEmpty() and not isBusy then
        if distance > 15 and mob:getBattleTime() > trebuchetTime then
            mob:useMobAbility(1636) -- trebuchet
            mob:setLocalVar("trebuchetTime", mob:getBattleTime() + math.random(15, 22))
        end
    end

    if venom == 1 then
        mob:removeListener("venomUSE")
        mob:setMod(xi.mod.REGEN, 0)
        mob:setLocalVar("venom", 2)
    end

    if wing == 1 then
        mob:removeListener("wingUSE")
        mob:setMod(xi.mod.CRITHITRATE, -50)
        mob:delMod(xi.mod.ATT, 100)
        mob:setLocalVar("wing", 2)
    end

    if moiety == 1 then
        mob:removeListener("moietyUSE")
        mob:setMod(xi.mod.UDMGPHYS, 0)
        mob:setMod(xi.mod.UDMGRANGE, 0)
        mob:setMod(xi.mod.UDMGMAGIC, 0)
        mob:setMod(xi.mod.UDMGBREATH, 0)
        mob:setLocalVar("moiety", 2)
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobWeaponSkillPrepare", function(mob, target)
    local random = math.random()
    if random <= 0.25 then
        return 662 -- Lightning Roar
    elseif random <= 0.50 then
        return 664 -- Impact Roar
    elseif random <= 0.75 then
        return 665 -- Grand Slam
    else
        return 667 -- Power Attack Weapon
    end
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("venomUSE")
    mob:removeListener("wingUSE")
    mob:removeListener("moietyUSE")
end)

m:addOverride("xi.zones.Dynamis-Qufim.mobs.Antaeus.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
end)

return m
