-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Jeuno
-- Mob: Wilywox Tenderpalm
-- !spawnmob 17547498
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_wilywox_tenderpalm")

xi.module.ensureTable("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm")

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setSpellList(970)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, 10) -- 425 total atk
    mob:addMod(xi.mod.DEF, 68) -- 450 total def
    mob:addMod(xi.mod.EVA, -9) -- 400 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.PERFECT_DODGE, cooldown = math.random(120, 180), hpp = math.random(92, 98)},
            {id = xi.jsa.BENEDICTION, hpp = 30,},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onMobFight", function(mob, target)
    local crit        = mob:getLocalVar("crit")
    local triple      = mob:getLocalVar("triple")
    local phase       = mob:getLocalVar("phase")
    local lifePercent = mob:getHPP()
    -- Bomb toss is doing 366 DMG at 100HPP to 1182 at 1HPP, no buffs/equipment/bonuses.
    local function scaleDamage(mobArg)
        local scalingFactor = 1 - (lifePercent / 100)
        local baseDamage = 275 -- Adjust this value as needed for the base damage of the weapon skill
        local scaledDamage = baseDamage * scalingFactor

        mobArg:addMod(xi.mod.MAIN_DMG_RATING, scaledDamage)
    end

    local function removeScaledDamage(mobArg)
        mobArg:delMod(xi.mod.MAIN_DMG_RATING, mob:getMod(xi.mod.MAIN_DMG_RATING))
    end

    if lifePercent < 11 and phase == 0 then
        mob:setLocalVar("phase", 1)
    end

    if phase == 1 then
        mob:setSpellList(969)
        mob:setMobMod(xi.mobMod.MAGIC_COOL, 15)
        mob:addMod(xi.mod.CURE_POTENCY, 50)
        mob:setLocalVar("phase", 2)
    end

    mob:addListener("WEAPONSKILL_STATE_ENTER", "bombStart", function(mobArg, skillID)
        local bombSkillID = 591 -- bomb toss

        if skillID == bombSkillID then
            scaleDamage(mobArg)
        end
    end)

    mob:addListener("WEAPONSKILL_STATE_EXIT", "bombEnd", function(mobArg, skillID)
        local bombSkillID = 591 -- bomb toss

        if skillID == bombSkillID then
            removeScaledDamage(mobArg)
        end
    end)

    mob:addListener("EFFECT_GAIN", "dodgeStart", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if math.random(1, 2) > 1 then
                mobArg:setMod(xi.mod.CRITHITRATE, 50)
                mobArg:setLocalVar("crit", mob:getLocalVar("crit") + 1)
            else
                mobArg:setMod(xi.mod.TRIPLE_ATTACK, 10)
                mobArg:setLocalVar("regen", mob:getLocalVar("triple") + 1)
            end
            mobArg:setTP(3000)
        end
    end)

    mob:addListener("EFFECT_LOSE", "dodgeEnd", function(mobArg, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if crit == 1 then
                mobArg:setMod(xi.mod.CRITHITRATE, -50)
                mobArg:setLocalVar("crit", 0)
            elseif triple == 1 then
                mobArg:setMod(xi.mod.TRIPLE_ATTACK, 0)
                mobArg:setLocalVar("triple", 0)
            end
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("bombStart")
    mob:removeListener("bombEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Wilywox_Tenderpalm.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("bombStart")
    mob:removeListener("bombEnd")
    mob:removeListener("shortProc")
end)

return m
