-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Jeuno
-- Mob: Scourquix Scaleskin
-- !spawnmob 17547496
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_scourquix_scaleskin")

xi.module.ensureTable("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin")

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onMobSpawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)
    mob:addMod(xi.mod.ACC, 29)  -- 450 total acc
    mob:addMod(xi.mod.RACC, 29) -- 450 total racc
    mob:addMod(xi.mod.DEF, 67)  -- 425 total def
    mob:addMod(xi.mod.EVA, 27)  -- 375 total eva
    pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
    SpawnMob(pet:getID())
    pet:updateEnmity(mob:getTarget())
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.EES_GOBLIN, hpp = 95},
            {id = xi.jsa.EES_GOBLIN, hpp = 75},
            {id = xi.jsa.EES_GOBLIN, hpp = 50},
            {id = xi.jsa.EES_GOBLIN, hpp = 25},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onMobFight", function(mob, target)
    local pet         = GetMobByID(mob:getID() + 1)
    local lifePercent = mob:getHPP()
    local drgSP       = mob:getLocalVar("drgSP")

    local function buffPet(mob)
        pet:setHP(pet:getMaxHP())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("drgSP", mob:getLocalVar("drgSP") + 1)
    end

    local function callPet(mob)
        pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
        SpawnMob(pet:getID())
        pet:updateEnmity(mob:getTarget())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("drgSP", mob:getLocalVar("drgSP") + 1)
    end

    if lifePercent < 81 and pet:isAlive() and drgSP == 0 then
        buffPet(mob)
    elseif lifePercent < 81 and pet:isDead() and drgSP == 0 then
        callPet(mob)
    elseif lifePercent < 61 and pet:isAlive() and drgSP == 1 then
        buffPet(mob)
    elseif lifePercent < 61 and pet:isDead() and drgSP == 1 then
        callPet(mob)
    elseif lifePercent < 41 and pet:isAlive() and drgSP == 2 then
        buffPet(mob)
    elseif lifePercent < 41 and pet:isDead() and drgSP == 2 then
        callPet(mob)
    elseif lifePercent < 21 and pet:isAlive() and drgSP == 3 then
        buffPet(mob)
    elseif lifePercent < 21 and pet:isDead() and drgSP == 3 then
        callPet(mob)
    end

    mob:addListener("EFFECT_GAIN", "eesStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.EES_GOBLIN then
            mob:resetEnmity(target)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onMobDespawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("eesStart")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Scourquix_Scaleskin.onMobDeath", function(mob, player, optParams)
    local pet = GetMobByID(mob:getID() + 1)

    DespawnMob(pet:getID())
    mob:resetLocalVars()
    mob:removeListener("eesStart")
    mob:removeListener("shortProc")
end)

return m
