-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Jeuno
-- Mob: Quicktrix Hexhands
-- !spawnmob 17547493
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_quicktrix_hexhands")

xi.module.ensureTable("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands")

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.FIRE_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MULTI_HIT, 1)
    mob:setSpellList(971) -- enfeebles
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 15)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.RACC, 39) -- 400 total racc
    mob:addMod(xi.mod.ATT, 9)   -- 450 total atk
    mob:addMod(xi.mod.DEF, 70)  -- 450 total def
    mob:addMod(xi.mod.EVA, 35)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(90, 120),
        specials = {
            {id = xi.jsa.CHAINSPELL, hpp = 100, cooldown = 0},
            {
                id = xi.jsa.MIJIN_GAKURE,
                hpp = math.random(50, 55),
                cooldown = 0,
                begCode = function(mobArg)
                    mob:setLocalVar("ninSP", 1)
                    mob:setLocalVar("ninMode", 1)
                end
            }
        }
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onMobFight", function(mob, target)
    local ninSP   = mob:getLocalVar("ninSP")
    local ninMode = mob:getLocalVar("ninMode")
    local recast  = mob:getLocalVar("recast")
    local isBusy  = false
    local act    = mob:getCurrentAction()

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    if mob:actionQueueEmpty() and not isBusy then
        if ninMode == 1 then
            if os.time() > recast then
                if mob:actionQueueEmpty() and not isBusy then
                    if not mob:hasStatusEffect(xi.effect.COPY_IMAGE) then
                        if math.random(1, 2) == 1 then
                            mob:castSpell(xi.magic.spell.UTSUSEMI_SAN, mob)
                            mob:setLocalVar("recast", os.time() + 12)
                        else
                            mob:castSpell(xi.magic.spell.UTSUSEMI_NI, mob)
                            mob:setLocalVar("recast", os.time() + 15)
                        end
                    end
                end
            end
        end
    end

    if xi.jobAbility.MIJIN_GAKURE and ninSP == 1 then
        mob:setSpellList(968) -- nin spells
        mob:setLocalVar("ninSP", 0)
    end

    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            if math.random(1, 2) > 1 then
                mob:setSpellList(972) -- nukes
            else
                mob:setSpellList(971) -- buffs
            end
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(973) -- enfeebles
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Jeuno.mobs.Quicktrix_Hexhands.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("shortProc")
end)

return m
