-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Buburimu
--  Mob: Lost_Barong
-- !spawnmob 16941520
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_lost_barong")

xi.module.ensureTable("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong")

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 90)
    mob:setMod(xi.mod.ICE_MEVA, 90)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 90)
    mob:setMod(xi.mod.THUNDER_MEVA, 90)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 100)
    mob:setMod(xi.mod.ICE_SDT, 100)
    mob:setMod(xi.mod.WIND_SDT, 100)
    mob:setMod(xi.mod.EARTH_SDT, 100)
    mob:setMod(xi.mod.THUNDER_SDT, 100)
    mob:setMod(xi.mod.WATER_SDT, 100)
    mob:setMod(xi.mod.LIGHT_SDT, 100)
    mob:setMod(xi.mod.DARK_SDT, 100)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 150)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 10)
    mob:addMod(xi.mod.ATT, 75)
    mob:addStatusEffect(xi.effect.REGAIN, 3, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
    mob:addMod(xi.mod.EVA, -15)
    mob:addMod(xi.mod.MOVE_SPEED_STACKABLE, 25)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobFight", function(mob, target)
    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobWeaponSkillPrepare", function(mob, target)
    local random = math.random()
    if random <= 0.5 then
        return 645 -- bodyslam
    else
        return 646 -- heavy_stomp
    end
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Lost_Barong.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

return m
