-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Buburimu
-- Mob: Arch Apocalyptic Beast
-- Note: This monster has unique interactions with itemIDs 5898, 5899, 5900, 5901, 5902
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_arch_apocalyptic_beast")

xi.module.ensureTable("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast")

local specialID = {
    688, -- MIGHTY_STRIKES
    690, -- HUNDRED_FISTS
    689, -- BENEDICTION
    691, -- MANAFONT
    692, -- CHAINSPELL
    693, -- PERFECT_DODGE
    694, -- INVINCIBLE
    695, -- BLOOD_WEAPON
    696, -- SOUL_VOICE
    730, -- MEIKYO_SHISUI
    731, -- MIJIN_GAKURE
}

local currentIndex = 1


m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 90)
    mob:setMod(xi.mod.ICE_MEVA, 90)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 90)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 100)
    mob:setMod(xi.mod.ICE_SDT, 100)
    mob:setMod(xi.mod.WIND_SDT, 100)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 100)
    mob:setMod(xi.mod.WATER_SDT, 100)
    mob:setMod(xi.mod.LIGHT_SDT, 100)
    mob:setMod(xi.mod.DARK_SDT, 100)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 15)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(20, 25))
    mob:addMod(xi.mod.ATT, 100)
    mob:addMod(xi.mod.DEF, 125)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 25)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:setSpellList(972)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
    mob:addMod(xi.mod.MOVE_SPEED_STACKABLE, 25)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobSpawn", function(mob)
    local specialId = specialID[currentIndex]
    mob:setLocalVar("specialId", specialId)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes

    mob:addListener("EFFECT_GAIN", "heartUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.STR_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("heart", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "talonUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.DEX_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("talon", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "skullUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.VIT_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("skull", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "femurUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.AGI_BOOST then
            mob:weaknessTrigger(2)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("femur", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "bloodUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.INT_BOOST then
            mob:weaknessTrigger(3)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("blood", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobEngage", function(mob, target)
    mob:setLocalVar("fightTime", 0)
    mob:setLocalVar("spUsed", 0)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobFight", function(mob, target)
    local fightTIME = mob:getLocalVar("fightTIME")
    local intervalTIME = 60
    local isBusy = false
    local act = mob:getCurrentAction()
    local spPhase = mob:getLocalVar("spPhase")
    local spUsed = mob:getLocalVar("spUsed")
    local heart = mob:getLocalVar("heart")
    local talon = mob:getLocalVar("talon")
    local skull = mob:getLocalVar("skull")
    local femur = mob:getLocalVar("femur")
    local blood = mob:getLocalVar("blood")

    if heart == 1 then
        mob:removeListener("heartUSE")
        mob:setLocalVar("heart", 2)
    end

    if talon == 1 then
        mob:removeListener("talonUSE")
        mob:setLocalVar("talon", 2)
    end

    if skull == 1 then
        mob:removeListener("skullUSE")
        mob:setLocalVar("skull", 2)
    end

    if femur == 1 then
        mob:removeListener("femurUSE")
        mob:setLocalVar("femur", 2)
    end

    if blood == 1 then
        mob:removeListener("bloodUSE")
        mob:setLocalVar("blood", 2)
    end

    local function useSP(mob)
        local currentSpecialID = specialID[currentIndex]
        mob:useMobAbility(currentSpecialID)
        mob:setLocalVar("fightTIME", mob:getBattleTime())
        currentIndex = currentIndex + 1
        if currentIndex > #specialID then
            currentIndex = 1
        end
    end

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    if blood ~= 2 then
        if mob:actionQueueEmpty() and not isBusy then
            if spPhase == 0 then
                mob:setLocalVar("fightTIME", mob:getBattleTime())
                mob:setLocalVar("spPhase", 1)
            elseif mob:getBattleTime() - fightTIME > intervalTIME then
                useSP(mob)
                mob:setLocalVar("spUsed", mob:getBattleTime())
            end
        end
    end

    local specialAbilities = {
        xi.effect.MIGHTY_STRIKES,
        xi.effect.HUNDRED_FISTS,
        xi.effect.MANAFONT,
        xi.effect.CHAINSPELL,
        xi.effect.PERFECT_DODGE,
        xi.effect.INVINCIBLE,
        xi.effect.BLOOD_WEAPON,
        xi.effect.SOUL_VOICE,
        xi.effect.MEIKYO_SHISUI,
    }

    if mob:getBattleTime() - spUsed > 30 then
        for _, effectID in ipairs(specialAbilities) do
            if mob:hasStatusEffect(effectID) then
                mob:delStatusEffect(effectID)
                mob:setLocalVar("spUsed", 0)
            end
        end
    end

    if mob:hasStatusEffect(xi.effect.MEIKYO_SHISUI) then
        mob:setMagicCastingEnabled(false)
        if mob:getLocalVar("wsOrder") == 0 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 1)
            mob:setTP(3000)
        elseif mob:getLocalVar("wsOrder") == 1 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 2)
            mob:setTP(2000)
        elseif mob:getLocalVar("wsOrder") == 2 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 3)
            mob:setTP(1000)
        elseif mob:getLocalVar("wsOrder") == 3 then
            mob:setLocalVar("wsOrder", 4)
        end
    end

    mob:addListener("EFFECT_LOSE", "samEnd", function(mob, effect)

        if effect:getEffectType() == xi.effect.MEIKYO_SHISUI then
            mob:setLocalVar("wsOrder", 0)
            mob:setMagicCastingEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "blmStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:setSpellList(966) -- nukes+death
        end
    end)

    mob:addListener("EFFECT_LOSE", "blmEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:setSpellList(972)
        end
    end)

    mob:addListener("EFFECT_GAIN", "voiceStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(978)
        end
    end)

    mob:addListener("EFFECT_LOSE", "voiceEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(972)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 5000
    })
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobWeaponSkillPrepare", function(mob, target)
    local heart = mob:getLocalVar("heart")
    local talon = mob:getLocalVar("talon")
    local skull = mob:getLocalVar("skull")
    local femur = mob:getLocalVar("femur")

    local random = math.random()

    -- Define probability distributions for different combinations of variables
    local distributions = {

        [0] = {0.10, 0.20, 0.30, 0.40, 0.50, 0.60, 0.70, 0.80, 0.90, 1.00}, -- Combination 0000 (all vars are 0)
        [1] = {0.10, 0.20, 0.30, 0.40, 0.50, 0.60, 0.70, 0.72, 0.86, 1.00}, -- Combination 0001 (heart == 2)
        [2] = {0.12, 0.24, 0.36, 0.48, 0.60, 0.62, 0.64, 0.76, 0.88, 1.00}, -- Combination 0010 (talon == 2)
        [3] = {0.13, 0.26, 0.39, 0.52, 0.65, 0.68, 0.71, 0.74, 0.87, 1.00}, -- Combination 0011 (heart == 2, talon == 2)
        [4] = {0.03, 0.06, 0.09, 0.22, 0.35, 0.48, 0.61, 0.74, 0.87, 1.00}, -- Combination 0100 (skull == 2)
        [5] = {0.04, 0.08, 0.12, 0.26, 0.40, 0.54, 0.68, 0.72, 0.86, 1.00}, -- Combination 0101 (heart == 2, skull == 2)
        [6] = {0.02, 0.04, 0.06, 0.24, 0.42, 0.44, 0.46, 0.64, 0.82, 1.00}, -- Combination 0110 (talon == 2, skull == 2)
        [7] = {0.02, 0.04, 0.06, 0.28, 0.50, 0.52, 0.54, 0.56, 0.78, 1.00}, -- Combination 0111 (heart == 2, talon == 2, skull == 2)
        [8] = {0.12, 0.24, 0.36, 0.38, 0.40, 0.52, 0.64, 0.76, 0.88, 1.00}, -- Combination 1000 (femur == 2)
        [9] = {0.13, 0.26, 0.39, 0.52, 0.55, 0.68, 0.81, 0.84, 0.87, 1.00}, -- Combination 1001 (heart == 2, femur == 2)
        [10] = {0.14, 0.28, 0.42, 0.46, 0.50, 0.54, 0.58, 0.72, 0.86, 1.00}, -- Combination 1010 (talon == 2, femur == 2)
        [11] = {0.18, 0.38, 0.54, 0.56, 0.58, 0.60, 0.62, 0.64, 0.82, 1.00}, -- Combination 1011 (heart == 2, talon == 2, femur == 2)
        [12] = {0.02, 0.04, 0.06, 0.08, 0.10, 0.28, 0.46, 0.64, 0.82, 1.00}, -- Combination 1100 (skull == 2, femur == 2)
        [13] = {0.02, 0.04, 0.06, 0.08, 0.10, 0.32, 0.54, 0.56, 0.78, 1.00}, -- Combination 1101 (heart == 2, skull == 2, femur == 2)
        [14] = {0.04, 0.08, 0.12, 0.16, 0.20, 0.24, 0.28, 0.52, 0.76, 1.00}, -- Combination 1110 (talon == 2, skull == 2, femur == 2)
        [15] = {0.03, 0.06, 0.09, 0.12, 0.15, 0.18, 0.21, 0.24, 0.62, 1.00}, -- Combination 1111 (heart == 2, talon == 2, skull == 2, femur == 2)
    }

    -- Determine the combination based on variable states
    local combination = (heart == 2 and 1 or 0) + (talon == 2 and 2 or 0) + (skull == 2 and 4 or 0) + (femur == 2 and 8 or 0)
    local distribution = distributions[combination]

    -- Determine the skill based on the random number and selected distribution
    for i = 1, #distribution do
        if random <= distribution[i] then
            -- Return the corresponding skill based on the index
        return (i == 1 and 642) or  -- Flame Breath (642)
               (i == 2 and 643) or  -- Poison Breath (643)
               (i == 3 and 644) or  -- Wind Breath (644)
               (i == 4 and 645) or  -- Body Slam (645)
               (i == 5 and 646) or  -- Heavy Stomp (646)
               (i == 6 and 647) or  -- Chaos Blade (647)
               (i == 7 and 648) or  -- Petro Eyes (648)
               (i == 8 and 649) or  -- Voidsong (649)
               (i == 9 and 650) or  -- Thornsong (650)
               (i == 10 and 651)    -- Lodesong (651)
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("blmStart")
    mob:removeListener("blmEnd")
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
    mob:removeListener("samEnd")
    mob:removeListener("heartUSE")
    mob:removeListener("talonUSE")
    mob:removeListener("skullUSE")
    mob:removeListener("femurUSE")
    mob:removeListener("bloodUSE")
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Arch_Apocalyptic_Beast.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
end)

return m
