-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Buburimu
-- Mob: Apocalyptic_Beast
-- Note: This monster has unique interactions with itemIDs 5898, 5899, 5900, 5901, 5902
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_apocalyptic_beast")

xi.module.ensureTable("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast")

local specialID = {
    688, -- MIGHTY_STRIKES
    690, -- HUNDRED_FISTS
    689, -- BENEDICTION
    691, -- MANAFONT
    692, -- CHAINSPELL
    693, -- PERFECT_DODGE
    694, -- INVINCIBLE
    695, -- BLOOD_WEAPON
    696, -- SOUL_VOICE
    730, -- MEIKYO_SHISUI
    731, -- MIJIN_GAKURE
}

local currentIndex = 1


m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 15)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(20, 25))
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)

    mob:setSpellList(972)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobSpawn", function(mob)
    local specialId = specialID[currentIndex]
    mob:setLocalVar("specialId", specialId)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes

    mob:addListener("EFFECT_GAIN", "heartUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.STR_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("heart", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "talonUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.DEX_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("talon", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "skullUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.VIT_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("skull", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "femurUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.AGI_BOOST then
            mob:weaknessTrigger(2)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("femur", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "bloodUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.INT_BOOST then
            mob:weaknessTrigger(3)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("blood", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobEngage", function(mob, target)
    mob:setLocalVar("fightTime", 0)
    mob:setLocalVar("spUsed", 0)
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobFight", function(mob, target)
    local fightTIME = mob:getLocalVar("fightTIME")
    local intervalTIME = 60
    local isBusy = false
    local act = mob:getCurrentAction()
    local spPhase = mob:getLocalVar("spPhase")
    local specialId = mob:getLocalVar("specialId")
    local spUsed = mob:getLocalVar("spUsed")
    local wsOrder = mob:getLocalVar("wsOrder")
    local heart = mob:getLocalVar("heart")
    local talon = mob:getLocalVar("talon")
    local skull = mob:getLocalVar("skull")
    local femur = mob:getLocalVar("femur")
    local blood = mob:getLocalVar("blood")

    if heart == 1 then
        mob:removeListener("heartUSE")
        mob:setLocalVar("heart", 2)
    end

    if talon == 1 then
        mob:removeListener("talonUSE")
        mob:setLocalVar("talon", 2)
    end

    if skull == 1 then
        mob:removeListener("skullUSE")
        mob:setLocalVar("skull", 2)
    end

    if femur == 1 then
        mob:removeListener("femurUSE")
        mob:setLocalVar("femur", 2)
    end

    if blood == 1 then
        mob:removeListener("bloodUSE")
        mob:setLocalVar("blood", 2)
    end

    local function useSP(mob)
        local currentSpecialID = specialID[currentIndex]
        mob:useMobAbility(currentSpecialID)
        mob:setLocalVar("fightTIME", mob:getBattleTime())
        currentIndex = currentIndex + 1
        if currentIndex > #specialID then
            currentIndex = 1
        end
    end

    isBusy = act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH

    if blood ~= 2 then
        if mob:actionQueueEmpty() and not isBusy then
            if spPhase == 0 then
                mob:setLocalVar("fightTIME", mob:getBattleTime())
                mob:setLocalVar("spPhase", 1)
            elseif mob:getBattleTime() - fightTIME > intervalTIME then
                useSP(mob)
                mob:setLocalVar("spUsed", mob:getBattleTime())
            end
        end
    end

    local specialAbilities = {
        xi.effect.MIGHTY_STRIKES,
        xi.effect.HUNDRED_FISTS,
        xi.effect.MANAFONT,
        xi.effect.CHAINSPELL,
        xi.effect.PERFECT_DODGE,
        xi.effect.INVINCIBLE,
        xi.effect.BLOOD_WEAPON,
        xi.effect.SOUL_VOICE,
        xi.effect.MEIKYO_SHISUI,
    }

    if mob:getBattleTime() - spUsed > 30 then
        for _, effectID in ipairs(specialAbilities) do
            if mob:hasStatusEffect(effectID) then
                mob:delStatusEffect(effectID)
                mob:setLocalVar("spUsed", 0)
            end
        end
    end

    if mob:hasStatusEffect(xi.effect.MEIKYO_SHISUI) then
        mob:setMagicCastingEnabled(false)
        if mob:getLocalVar("wsOrder") == 0 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 1)
            mob:setTP(3000)
        elseif mob:getLocalVar("wsOrder") == 1 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 2)
            mob:setTP(2000)
        elseif mob:getLocalVar("wsOrder") == 2 then
            mob:useMobAbility(645) -- body_slam
            mob:setLocalVar("wsOrder", 3)
            mob:setTP(1000)
        elseif mob:getLocalVar("wsOrder") == 3 then
            mob:setLocalVar("wsOrder", 4)
        end
    end

    mob:addListener("EFFECT_LOSE", "samEnd", function(mob, effect)
        local wsOrder = mob:getLocalVar("wsOrder")

        if effect:getEffectType() == xi.effect.MEIKYO_SHISUI then
            mob:setLocalVar("wsOrder", 0)
            mob:setMagicCastingEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "blmStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:setSpellList(966) -- nukes+death
        end
    end)

    mob:addListener("EFFECT_LOSE", "blmEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:setSpellList(972)
        end
    end)

    mob:addListener("EFFECT_GAIN", "voiceStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(978)
        end
    end)

    mob:addListener("EFFECT_LOSE", "voiceEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(972)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobWeaponSkillPrepare", function(mob, target)
    local heart = mob:getLocalVar("heart")
    local talon = mob:getLocalVar("talon")
    local skull = mob:getLocalVar("skull")
    local femur = mob:getLocalVar("femur")
    local availableSkills = {642, 643, 644, 645, 646, 647, 648, 649, 650, 651}
    local skillsToRemove = {}  -- Store skills to remove based on conditions

    -- Function to remove skills from the availableSkills table
    local function removeSkills(availableSkills, skillsToRemove)
        for i = #availableSkills, 1, -1 do
            local skill = availableSkills[i]
            if skillsToRemove[skill] then
                table.remove(availableSkills, i)
            end
        end
    end

    -- Check if all conditions are met and disable mob ability
    if heart == 2 and talon == 2 and skull == 2 and femur == 2 then
        mob:setMobAbilityEnabled(false)
        mob:setSpellList(972)
        return 0
    end

    -- Define skills to remove based on conditions
    if heart == 2 then
        skillsToRemove[649] = true
        skillsToRemove[650] = true
        skillsToRemove[651] = true
    end

    if talon == 2 then
        skillsToRemove[647] = true
        skillsToRemove[648] = true
    end

    if skull == 2 then
        skillsToRemove[642] = true
        skillsToRemove[643] = true
        skillsToRemove[644] = true
    end

    if femur == 2 then
        skillsToRemove[645] = true
        skillsToRemove[646] = true
    end

    -- Remove skills based on conditions
    removeSkills(availableSkills, skillsToRemove)

    -- If none of the conditions are met, availableSkills remains unchanged
    if #availableSkills > 0 then
        local randomIndex = math.random(1, #availableSkills)
        local selectedSkill = availableSkills[randomIndex]
        return selectedSkill
    else
        return 0
    end
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("blmStart")
    mob:removeListener("blmEnd")
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
    mob:removeListener("samEnd")
    mob:removeListener("heartUSE")
    mob:removeListener("talonUSE")
    mob:removeListener("skullUSE")
    mob:removeListener("femurUSE")
    mob:removeListener("bloodUSE")
end)

m:addOverride("xi.zones.Dynamis-Buburimu.mobs.Apocalyptic_Beast.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
end)

return m
