-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Beaucedine
-- Mob: Pignonpausard
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_pignonpausard")

xi.module.ensureTable("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard")

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 10, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
    mob:addMod(xi.mod.EVA, -15)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobSpawn", function(mob)

    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -16) -- 425 total atk
    mob:addMod(xi.mod.DEF, 40)  -- 425 total def
    mob:addMod(xi.mod.EVA, 40)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials = {
            {
                id = xi.jsa.MEIKYO_SHISUI,
                duration = 8,
                cooldown = math.random(90, 120),
                hpp = 95,
                begCode = function(mobArg)
                    mob:setMagicCastingEnabled(false)
                end
            },
            {
                id = xi.jsa.BENEDICTION,
                hpp = 50,
                begCode = function(mobArg)
                    mob:setLocalVar("phase", 1)
                    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(25, 35))
                    mob:addMod(xi.mod.CURE_POTENCY, 50)
                end
            },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobFight", function(mob, target)
    local act = mob:getCurrentAction()
    local isBusy = false
    local wsOrder = mob:getLocalVar("wsOrder")

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

	if mob:actionQueueEmpty() and not isBusy then
		if mob:hasStatusEffect(xi.effect.MEIKYO_SHISUI) then
			if wsOrder == 0 then
				mob:useMobAbility(250) -- carnal nightmare
				mob:setLocalVar("wsOrder", 1)
				mob:setTP(3000)
			elseif wsOrder == 1 then
				mob:useMobAbility(252) -- dancing chains
				mob:setLocalVar("wsOrder", 2)
				mob:setTP(2000)
			elseif wsOrder == 2 then
				mob:useMobAbility(251) -- aegis schism
				mob:setLocalVar("wsOrder", 3)
				mob:setTP(1000)
			elseif wsOrder == 3 then
				mob:useMobAbility(247) -- fox fire
				mob:setLocalVar("wsOrder", 4)
				mob:setTP(0)
			elseif wsOrder == 4 then
				mob:setLocalVar("wsOrder", 5)
			end
		end
	end

    mob:addListener("EFFECT_LOSE", "samEnd", function(mob, effect)

        if effect:getEffectType() == xi.effect.MEIKYO_SHISUI then
            mob:setLocalVar("wsOrder", 0)
            mob:setMagicCastingEnabled(true)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobMagicPrepare", function(mob, target, spellId)
    local phase = mob:getLocalVar("phase")

    if phase == 1 then
        return 6 -- cure_vi
    end
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("samEnd")
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Pignonpausard.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("samEnd")
end)

return m
