-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Beaucedine
-- Mob: Hitaume
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_hitaume")

xi.module.ensureTable("xi.zones.Dynamis-Beaucedine.mobs.Hitaume")

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 10, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 20)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onMobSpawn", function(mob)
    mob:addMod(xi.mod.ATT, -51) -- 425 total atk
    mob:addMod(xi.mod.DEF, 6)   -- 425 total def
    mob:addMod(xi.mod.EVA, 28)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.MIGHTY_STRIKES, cooldown = math.random(120, 180), hpp = math.random(85, 90)},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onMobFight", function(mob, target)
    local double = mob:getLocalVar("double")
    local regen  = mob:getLocalVar("regen")
    local lifePercent = mob:getHPP()
    local act = mob:getCurrentAction()
    local isBusy = false
    local eesCount = mob:getLocalVar("eesCount")

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function eeShot(mob)
		if mob:actionQueueEmpty() and not isBusy then
			mob:useMobAbility(738)
			mob:setLocalVar("eesCount", eesCount + 1)
		end
	end

    if lifePercent <= 75 and eesCount == 0 then
        eeShot(mob)
    elseif lifePercent <= 50 and eesCount == 1 then
        eeShot(mob)
    elseif lifePercent <= 25 and eesCount == 2 then
        eeShot(mob)
    end

    mob:addListener("EFFECT_GAIN", "warStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            if math.random(1, 2) > 1 then
                mob:setMod(xi.mod.DOUBLE_ATTACK, 40)
                mob:setLocalVar("double", mob:getLocalVar("double") + 1)
            else
                mob:setMod(xi.mod.REGEN, 250)
                mob:setLocalVar("regen", mob:getLocalVar("regen") + 1)
            end
            mob:setTP(3000)
        end
    end)

    mob:addListener("EFFECT_LOSE", "warEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            if double == 1 then
                mob:setMod(xi.mod.DOUBLE_ATTACK, 20)
                mob:setLocalVar("double", 0)
            elseif regen == 1 then
                mob:setMod(xi.mod.REGEN, 0)
                mob:setLocalVar("regen", 0)
            end
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Hitaume.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
end)

return m
