-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Beaucedine
-- Mob: Cavanneche
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_cavanneche")

xi.module.ensureTable("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche")

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 10, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -69) -- 450 total atk
    mob:addMod(xi.mod.DEF, 41)  -- 425 total def
    mob:addMod(xi.mod.EVA, 37)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials = {
            { id = xi.jsa.BLOOD_WEAPON, hpp = math.random(85, 90), cooldown = 0 },
            {
                id = xi.jsa.MANAFONT,
                cooldown = 0,
                hpp = math.random(92, 98),
                begCode = function(mobArg)
                    mob:setSpellList(967) -- BLM spells
                    mob:setMobAbilityEnabled(false)
                end
            },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onMobFight", function(mob, target)
    mob:addListener("EFFECT_GAIN", "drkStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 5)
            mob:setMagicCastingEnabled(false)
            mob:setMobAbilityEnabled(false)
        end
    end)

    mob:addListener("EFFECT_LOSE", "drkEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 0)
            mob:setMagicCastingEnabled(true)
            mob:setMobAbilityEnabled(true)
        end
    end)

    mob:addListener("EFFECT_LOSE", "blmEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:setSpellList(975) -- DRK spells
            mob:setMobAbilityEnabled(true)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("drkStart")
    mob:removeListener("drkEnd")
    mob:removeListener("blmEnd")
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Cavanneche.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("drkStart")
    mob:removeListener("drkEnd")
    mob:removeListener("blmEnd")
end)

return m
