-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Beaucedine
-- Mob: Arch_Angra_Mainyu
-- Note: Mega Boss
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
-----------------------------------
local m = Module:new("dyna_2_0_arch_angra_mainyu")

xi.module.ensureTable("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu")

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.BLIND)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 100)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 100)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(22, 30))
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setSpellList(967)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu.onMobSpawn", function(mob)
    -- Default setup
    local specialId = 692

    mob:setUnkillable(true)
    mob:setLocalVar("specialId", specialId)
    mob:setModelId(266)
    mob:setLocalVar("[rage]timer", 3600)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, 64)  -- 500 total atk
    mob:addMod(xi.mod.DEF, 121) -- 500 total def
    mob:addMod(xi.mod.EVA, 39)  -- 375 total eva
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu.onMobFight", function(mob, target)
    local lifePercent = mob:getHPP()
    local phase       = mob:getLocalVar("phase")
    local isBusy      = false
    local act         = mob:getCurrentAction()
    local specialId   = mob:getLocalVar("specialId")
    local deathRecast = mob:getLocalVar("deathRecast")

    xi.mix.jobSpecial.config(mob, {
        specials = {
            { id = specialId, hpp = math.random(92, 98), cooldown = math.random(120, 150) }
        },
    })

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    local function Ahriman(mob)
        if mob:actionQueueEmpty() and not isBusy then
            if mob:hasStatusEffect(xi.effect.MANAFONT) then
                mob:delStatusEffect(xi.effect.MANAFONT)
            elseif mob:hasStatusEffect(xi.effect.MIGHTY_STRIKES) then
                mob:delStatusEffect(xi.effect.MIGHTY_STRIKES)
            end
            mob:entityAnimationPacket("casm")
            mob:setAutoAttackEnabled(false)
            mob:setMobAbilityEnabled(false)
            mob:setMagicCastingEnabled(false)
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.STANDBACK))
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))

            mob:timer(3000, function(mobArg)
                if mob:isAlive() then
                    mobArg:entityAnimationPacket("shsm")
                    mob:setAutoAttackEnabled(true)
                    mob:setMobAbilityEnabled(true)
                    mob:setMagicCastingEnabled(true)
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.STANDBACK)))
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.NO_TURN)))
                    mob:setHP(mob:getMaxHP())
                    mob:setModelId(266)
                    mob:setSpellList(967)
                    mob:setMobMod(xi.mobMod.SKILL_LIST, 4)
                    mob:setLocalVar("phase", phase + 1)
                    mob:setLocalVar("specialId", 692)
                end
            end)
        end
    end

    local function Statue(mob)
        if mob:actionQueueEmpty() and not isBusy then
            if mob:hasStatusEffect(xi.effect.CHAINSPELL) then
                mob:delStatusEffect(xi.effect.CHAINSPELL)
            elseif mob:hasStatusEffect(xi.effect.MIGHTY_STRIKES) then
                mob:delStatusEffect(xi.effect.MIGHTY_STRIKES)
            end
            mob:entityAnimationPacket("casm")
            mob:setAutoAttackEnabled(false)
            mob:setMobAbilityEnabled(false)
            mob:setMagicCastingEnabled(false)
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.STANDBACK))
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))

            mob:timer(3000, function(mobArg)
                if mob:isAlive() then
                    mobArg:entityAnimationPacket("shsm")
                    mob:setAutoAttackEnabled(true)
                    mob:setMobAbilityEnabled(true)
                    mob:setMagicCastingEnabled(true)
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.STANDBACK)))
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.NO_TURN)))
                    mob:setHP(mob:getMaxHP())
                    mob:setModelId(1061)
                    mob:setSpellList(967)
                    mob:setMobMod(xi.mobMod.SKILL_LIST, 5022)
                    mob:setLocalVar("phase", phase + 1)
                    mob:setLocalVar("specialId", 691)
                end
            end)
        end
    end

    local function Dragon(mob)
        if mob:actionQueueEmpty() and not isBusy then
            if mob:hasStatusEffect(xi.effect.CHAINSPELL) then
                mob:delStatusEffect(xi.effect.CHAINSPELL)
            elseif mob:hasStatusEffect(xi.effect.MANAFONT) then
                mob:delStatusEffect(xi.effect.MANAFONT)
            end
            mob:entityAnimationPacket("casm")
            mob:setAutoAttackEnabled(false)
            mob:setMobAbilityEnabled(false)
            mob:setMagicCastingEnabled(false)
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.STANDBACK))
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))

            mob:timer(3000, function(mobArg)
                if mob:isAlive() then
                    mobArg:entityAnimationPacket("shsm")
                    mob:setAutoAttackEnabled(true)
                    mob:setMobAbilityEnabled(true)
                    mob:setMagicCastingEnabled(true)
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.STANDBACK)))
                    mob:setBehaviour(bit.band(mob:getBehaviour(), bit.bnot(xi.behavior.NO_TURN)))
                    mob:setHP(mob:getMaxHP())
                    mob:setModelId(420)
                    mob:setSpellList(0)
                    mob:setMobMod(xi.mobMod.SKILL_LIST, 87)
                    mob:setLocalVar("phase", phase + 1)
                    mob:setLocalVar("specialId", 688)
                end
            end)
        end
    end

    if lifePercent < 2 and phase == 0 then
        Statue(mob)
    elseif lifePercent < 2 and phase == 1 then
        Ahriman(mob)
    elseif lifePercent < 2 and phase == 2 then
        Dragon(mob)
    elseif lifePercent < 2 and phase == 3 then
        Ahriman(mob)
    end

    if phase == 4 then
        mob:setUnkillable(false)
    end

    if mob:actionQueueEmpty() and not isBusy then
        if phase == 0 or phase == 2 or phase == 4 then
            if os.time() > deathRecast then
                mob:castSpell(367, target) -- death spell
                mob:setLocalVar("deathRecast", os.time() + math.random(90, 120)) -- 1.5 - 2 mins
            end
        end
    end

    mob:addListener("EFFECT_GAIN", "blmStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:addMod(xi.mod.DEF, 500)
        end
    end)

    mob:addListener("EFFECT_LOSE", "blmEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MANAFONT then
            mob:addMod(xi.mod.DEF, -500)
        end
    end)

    mob:addListener("EFFECT_GAIN", "warStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:addMod(xi.mod.DEF, 500)
        end
    end)

    mob:addListener("EFFECT_LOSE", "warEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:addMod(xi.mod.DEF, -500)
        end
    end)

    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:addMod(xi.mod.DEF, 500)
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:addMod(xi.mod.DEF, -500)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("blmStart", "chainStart", "chainEnd", "blmEnd", "warStart", "warEnd")
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Arch_Angra_Mainyu.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("blmStart", "chainStart", "chainEnd", "blmEnd", "warStart", "warEnd")
end)

return m
