-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Beaucedine
-- Mob: Angra Mainyu
-- Note: Mega Boss
-----------------------------------
require("modules/module_utils")
require("scripts/globals/dynamis")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_angra_mainyu")

xi.module.ensureTable("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu")

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.BLIND)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.TELEPORT_CD, math.random(60, 120))
    mob:setMobMod(xi.mobMod.TELEPORT_START, 988)
    mob:setMobMod(xi.mobMod.TELEPORT_END, 989)
    mob:setMobMod(xi.mobMod.TELEPORT_TYPE, 1)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, math.random(18, 26))
    mob:setSpellList(973) -- Enfeebles
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.SIGHT_RANGE, 30)
    mob:updateEnmity(mob:getTarget())
    mob:addMod(xi.mod.ACC, 69) -- 400 total acc
    mob:addMod(xi.mod.ATT, 23) -- 425 total atk
    mob:addMod(xi.mod.DEF, 72) -- 425 total def
    mob:addMod(xi.mod.EVA, 72) -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials = {
            {id = xi.jsa.CHAINSPELL, cooldown = math.random(90, 120), hpp = math.random(92, 98)}
        }
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobEngage", function(mob, target)
    local mobId = mob:getID()

    for i = mobId + 1, mobId + 4 do
        if not GetMobByID(i):isSpawned() then
            local dahakPet = SpawnMob(i)
            dahakPet:updateEnmity(target)
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobFight", function(mob, target)
    local act         = mob:getCurrentAction()
    local deathRecast = mob:getLocalVar("deathRecast")
    local lifePercent = mob:getHPP()
    local isBusy      = false
    local phase       = mob:getLocalVar("phase")

    if lifePercent < 51 and phase == 0 then
        mob:setLocalVar("phase", 1)
    end

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

	if mob:actionQueueEmpty() and not isBusy then
		if phase == 1 then
			if os.time() > deathRecast then
				mob:castSpell(367, target) -- Death spell
				mob:setLocalVar("deathRecast", os.time() + math.random(120, 180)) -- 2 - 3 mins
			end
		end
	end

    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(972) -- Tier three nuke spells only.
            mob:setMobMod(xi.mobMod.TELEPORT_TYPE, 0) -- Don't warp around during chainspell.
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(973) -- Default, enfeebles only.
            mob:setMobMod(xi.mobMod.TELEPORT_TYPE, 1) -- Default warping.
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobMagicPrepare", function(mob, target, spellId)
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    for i = 1, 4 do
        DespawnMob(mob:getID() + i)
    end
end)

m:addOverride("xi.zones.Dynamis-Beaucedine.mobs.Angra_Mainyu.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    for i = 1, 4 do
        DespawnMob(mob:getID() + i)
    end
end)

return m
