-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Bastok
-- NM: Zo'Pha Forgesoul
-- !Spawnmob 17539307
-- !pos -131.000 -0.500 -68.000 186
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_zopha_forgesoul")

xi.module.ensureTable("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul")

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:addStatusEffect(xi.effect.ICE_SPIKES, 10, 0, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.WATER_ABSORB, 100)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.TP_DRAIN, {chance = 50, power = math.random(5, 20)})
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 25)
    mob:setSpellList(163)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, -9) -- 425 total atk
    mob:addMod(xi.mod.DEF, 45) -- 425 total def
    mob:addMod(xi.mod.EVA, 35) -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials =
        {
            { id = xi.jsa.MANAFONT, hpp = math.random(80, 90), cooldown = 0 },
            {
                id = xi.jsa.MEIKYO_SHISUI,
                duration = 8,
                cooldown = 0,
                hpp = math.random(92, 98),
                begCode = function(mobArg)
                    mob:setMagicCastingEnabled(false)
                end
            },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onMobFight", function(mob, target)
    local wsOrder = mob:getLocalVar("wsOrder")

    if mob:hasStatusEffect(xi.effect.MEIKYO_SHISUI) then
        if wsOrder == 0 then
            mob:useMobAbility(1074) --  Wrath of Gu'Dha
            mob:setLocalVar("wsOrder", 1)
            mob:setTP(3000)
        elseif wsOrder == 1 then
            mob:useMobAbility(1074) --  Wrath of Gu'Dha
            mob:setLocalVar("wsOrder", 2)
            mob:setTP(2000)
        elseif wsOrder == 2 then
            mob:useMobAbility(1074) --  Wrath of Gu'Dha
            mob:setLocalVar("wsOrder", 3)
            mob:setTP(0)
        elseif wsOrder == 3 then
            mob:setLocalVar("wsOrder", 4)
        end
    end

    mob:addListener("EFFECT_LOSE", "samEnd", function(mob, effect)

        if effect:getEffectType() == xi.effect.MEIKYO_SHISUI then
            mob:setLocalVar("wsOrder", 0)
            mob:setMagicCastingEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onSpellPrecast", function(mob, spell)
    if spell:getID() == 257 then -- Curse
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(30)
        spell:setMPCost(1)
    end
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("samEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.ZoPha_Forgesoul.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("samEnd")
    mob:removeListener("shortProc")
end)

return m
