-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Bastok
--  Mob: Va'Zhe Pummelsong
-- !Spawnmob 17539310
-- !pos -107.1880 12.0000 70.9023 186
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_vazhe_pummelsong")

xi.module.ensureTable("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong")

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.WATER_ABSORB, 100)
    mob:setMod(xi.mod.COUNTER, 15)
    mob:setMagicCastingEnabled(true)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
    mob:setSpellList(979)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.SILENCE, {chance = 50, power = math.random(5, 20)})
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -16) -- 425 total atk
    mob:addMod(xi.mod.DEF, 37)  -- 425 total def
    mob:addMod(xi.mod.EVA, 46)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials =
        {
            {id = xi.jsa.HUNDRED_FISTS, hpp = math.random(80, 90), cooldown = 0 },
            {id = xi.jsa.SOUL_VOICE, hpp = math.random(90, 98), cooldown = 0 },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onMobFight", function(mob, target)

    mob:addListener("EFFECT_GAIN", "voiceStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(978)
            mob:setMod(xi.mod.UFASTCAST, 50)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 20)
        end
    end)

    mob:addListener("EFFECT_LOSE", "voiceEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(979)
            mob:setMod(xi.mod.UFASTCAST, 25)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
        end
    end)

    mob:addListener("EFFECT_GAIN", "fistStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.HUNDRED_FISTS then
            mob:setMagicCastingEnabled(false)
            mob:useMobAbility(762)  -- Howl
            mob:setTP(3000)
            mob:useMobAbility(1074) -- Wrath of Gu'Dha
        end
    end)

    mob:addListener("EFFECT_LOSE", "fistEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.HUNDRED_FISTS then
            mob:setMagicCastingEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onSpellPrecast", function(mob, spell)
    if spell:getID() == 462 or  -- Magic Finale
        spell:getID() == 376 or -- Horde Lullaby
        spell:getID() == 463 or -- Foe Lullaby
        spell:getID() == 423    -- Massacre Elegy
    then
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(30)
    end
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
    mob:removeListener("fistStart")
    mob:removeListener("fistEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.VaZhe_Pummelsong.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
    mob:removeListener("fistStart")
    mob:removeListener("fistEnd")
    mob:removeListener("shortProc")
end)

return m
