-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Bastok
-- NM: RaGho Darkfount
-- !Spawnmob 17539308
-- !pos -188.6989 -8.6132 -21.9415 186
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_ragho_darkfount")

xi.module.ensureTable("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount")

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.WATER_ABSORB, 100)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {chance = 50, power = math.random(5, 20)})
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setSpellList(293)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, -69) -- 450 total atk
    mob:addMod(xi.mod.DEF, 41) -- 425 total def
    mob:addMod(xi.mod.EVA, 38) -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.BLOOD_WEAPON, hpp = math.random(80, 95), cooldown = 120},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobFight", function(mob, target)

    mob:addListener("EFFECT_GAIN", "zergStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 5)
        end
    end)

    mob:addListener("EFFECT_LOSE", "zergEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 0)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onSpellPrecast", function(mob, spell)
    if spell:getID() == 252 then -- Stun
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(30)
        spell:setMPCost(1)
    end
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("zergStart")
    mob:removeListener("zergEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("zergStart")
    mob:removeListener("zergEnd")
    mob:removeListener("shortProc")
end)

return m
