-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Bastok
--  Mob: Bu'Bho Truesteel
-- !Spawnmob 17539311
-- !pos 73.7238 7.0000 -34.8684 186
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_bubho_truesteel")

xi.module.ensureTable("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel")

m:addOverride("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 50)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 50)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addMod(xi.mod.CURE_POTENCY, 35)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMod(xi.mod.WATER_ABSORB, 100)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
    mob:setSpellList(977)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT, {power = math.random(16, 60)})
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, -21) -- 400 total acc
    mob:addMod(xi.mod.ATT, -20) -- 425 total atk
    mob:addMod(xi.mod.DEF, 23)  -- 475 total def
    mob:addMod(xi.mod.EVA, 38)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials =
        {
            { id = xi.jsa.EES_YAGUDO, hpp = math.random(80, 90), cooldown = 0 }, -- correct EES animation for this model
            { id = xi.jsa.INVINCIBLE, hpp = math.random(90, 98), cooldown = 0 },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel.onMobFight", function(mob, target)
    local invincible = mob:getLocalVar("invincible")
    local divine     = mob:getLocalVar("divine")

    mob:addListener("EFFECT_GAIN", "eesStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.EES_YAGUDO then
            mob:resetEnmity(target)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shieldStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.INVINCIBLE then
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 20)
            mob:addStatusEffect(xi.effect.DIVINE_SEAL, 1, 0, 0)
            mob:setLocalVar("invincible", 1)
            mob:setSpellList(976)
        end
    end)

    mob:addListener("EFFECT_LOSE", "cureBonus", function(mob, effect)
        if effect:getEffectType() == xi.effect.DIVINE_SEAL then
            mob:setLocalVar("divine", 0)
        end
    end)

    if invincible == 1 and divine == 0 then
        mob:addStatusEffect(xi.effect.DIVINE_SEAL, 1, 0, 0)
        mob:setLocalVar("divine", 1)
    end

    mob:addListener("EFFECT_LOSE", "shieldEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.INVINCIBLE then
            mob:setLocalVar("invincible", 0)
            mob:delStatusEffect(xi.effect.DIVINE_SEAL)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
            mob:setSpellList(977)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.BuBho_Truesteel.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("eesStart")
    mob:removeListener("shieldStart")
    mob:removeListener("shieldEnd")
    mob:removeListener("cureBonus")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Bastok.mobs.RaGho_Darkfount.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("eesStart")
    mob:removeListener("shieldStart")
    mob:removeListener("shieldEnd")
    mob:removeListener("cureBonus")
    mob:removeListener("shortProc")
end)

return m
