-----------------------------------
-- Area: Chamber of Oracles
--  Mob: Purson
-- KSNM30: The Scarlet King
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new('purson')

local modulePath = 'xi.zones.Chamber_of_Oracles.mobs.Purson'

xi.module.ensureTable(modulePath)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 40)
end)

m:addOverride(modulePath .. '.onMobEngage', function(mob)
    mob:setLocalVar('timer', os.time() + 10)
    mob:useMobAbility(800)
end)

m:addOverride(modulePath .. '.onMobWeaponSkillPrepare', function(mob, target)
    mob:setLocalVar('skill_tp', mob:getTP())
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    if mob:getLocalVar('timer') < os.time() then
        mob:useMobAbility(695)
        mob:setLocalVar('timer', os.time() + 45)
    end
end)

m:addOverride(modulePath .. '.onMobWeaponSkill', function(target, mob, skill)
    if skill:getID() == 695 then
        mob:addTP(mob:getLocalVar('skill_tp'))
        mob:setLocalVar('skill_tp', 0)
    end
end)

return m
