-----------------------------------
-- Area: Spire of Holla
-- Mob: Cogitator
-- ENM: Simulant
-----------------------------------
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.SPIRE_OF_HOLLA]
-----------------------------------
local m = Module:new('cogitator')

local modulePath = 'xi.zones.Spire_of_Holla.mobs.Cogitator'

xi.module.ensureTable('xi.zones.Spire_of_Holla.mobs.Cogitator')

m:addOverride(modulePath .. '.onMobEngaged', function(mob)
    mob:setLocalVar('timer', os.time() + math.random(20, 90))
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local id = mob:getID()
    local pos = mob:getPos()

    if mob:getLocalVar('timer') < os.time() and mob:getHPP() <= 55 then
        for i = 1, 3 do
            if not GetMobByID(id+i):isSpawned() then
                GetMobByID(id+i):setSpawn(pos.x, pos.y, pos.z)
                SpawnMob(id+i):updateEnmity(mob:getTarget())
                mob:setLocalVar('timer', os.time() + math.random(20,130))
                break
            end
        end
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    local id = mob:getID()

    if optParams.isKiller then
        for i = 1, 3 do
            if GetMobByID(id+i):isAlive() then
                GetMobByID(id+i):setHP(0)
            end
        end
    end
end)

return m
