-----------------------------------
-- Area: Mine Shaft #2716
-- Mob: Fantoccini Automaton
-- ENM: Totentanz
-----------------------------------
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.MINE_SHAFT_2716]
-----------------------------------

local m = Module:new('fantoccini_automaton')

xi.module.ensureTable('xi.zones.Mine_Shaft_2716.mobs.Fantoccini_Automaton')

local automatonTable =
{
    modelID = 1398,
    skillList = 5061,
    petModelID =
    {
        { 1983, xi.job.PLD }, -- Melee Automaton
        { 1990, xi.job.RNG }, -- Ranged Automaton
        { 1994, xi.job.BLM }, -- Magic Automaton
    },
    petSkillList =
    {
        364, -- Melee Automaton
        365, -- Ranged Automaton
        366, -- Magic Automaton
    },
    petSpellListID =
    {
        0, -- Melee Automaton
        0, -- Ranged Automaton
        2, -- Magic Automaton
    },
    ability = 1995, -- Maneuvers
    spellListID = 0,
    petID = 4,
    mods = {},
}

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini_Automaton.onMobSpawn', function(mob)
    mob:setUntargetable(false)
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini_Automaton.onMobFight', function(mob, target)
    local fantoccini = GetMobByID(ID.mob.FANTOCCINI[mob:getBattlefield():getArea()])
    local model = mob:getLocalVar('petModel')

    -- Ice Maneuver (Magic automaton casts spells)
    if
        fantoccini:getLocalVar('petModel') == 3 and
        mob:hasStatusEffect(xi.effect.ICE_MANEUVER)
    then
        mob:setMobMod(xi.mobMod.SPELL_LIST, automatonTable.petSpellList[model])
        mob:setMagicCastingEnabled(true)
    else
        mob:setMagicCastingEnabled(false)
    end

    -- Thunder Maneuver (Ranged automaton uses weapon skills)
    if
        fantoccini:getLocalVar('petModel') == 2 and
        mob:hasStatusEffect(xi.effect.ICE_MANEUVER)
    then
        mob:setMobMod(xi.mobMod.SKILL_LIST, automatonTable.petSkillList[model])
    else
        mob:setMobMod(xi.mobMod.SKILL_LIST, 0)
    end

    -- Fire Maneuver (Ranged and Magic automatons use weapon skills)
    if
        fantoccini:getLocalVar('petModel') ~= 2 and
        mob:hasStatusEffect(xi.effect.FIRE_MANEUVER)
    then
        mob:setMobMod(xi.mobMod.SKILL_LIST, automatonTable.petSkillList[model])
    else
        mob:setMobMod(xi.mobMod.SKILL_LIST, 0)
    end
end)

return m
