-----------------------------------
-- Area: Mine Shaft #2716
-- Mob: Fantoccini
-- ENM: Totentanz
-----------------------------------
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.MINE_SHAFT_2716]
-----------------------------------
local m = Module:new('fantoccini')

xi.module.ensureTable('xi.zones.Mine_Shaft_2716.mobs.Fantoccini')

local jobTable =
{
    [xi.job.WAR] =
    {
        modelID = 1209,
        skillList = 5049,
        ability = 1428, -- Warcry
        twoHour = 688, -- Mighty Strikes
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.MNK] =
    {
        modelID = 1210,
        skillList = 5050,
        ability = 1429, -- Counterstance
        twoHour = 690, -- Hundred Fists
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.WHM] =
    {
        modelID = 1214,
        skillList = 5051,
        ability = 0, -- None
        twoHour = 689, -- Benediction
        spellListID = 1,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -100, },
        },
    },

    [xi.job.BLM] =
    {
        modelID = 1215,
        skillList = 5051,
        ability = 0, -- None
        twoHour = 691, -- Manafont
        spellListID = 2,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -100 },
        },
    },

    [xi.job.RDM] =
    {
        modelID = 1216,
        skillList = 5053,
        ability = 0, -- None
        twoHour = 692, -- Chainspell
        spellListID = 3,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -50, },
        },
    },

    [xi.job.THF] =
    {
        modelID = 1218,
        skillList = 5054,
        ability = 0, -- None
        twoHour = 693, -- Perfect Dodge
        spellListID = 0,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -50, },
        },
    },

    [xi.job.PLD] =
    {
        modelID = 1219,
        skillList = 5053,
        ability = 1431, -- Shield Bash
        twoHour = 694, -- Incincible
        spellListID = 4,
        petID = 0,
        mods = {},
    },

    [xi.job.DRK] =
    {
        modelID = 1220,
        skillList = 5055,
        ability = 1432, -- Weapon Bash
        twoHour = 695, -- Blood Weapon
        spellListID = 5,
        petID = 0,
        mods = {},
    },

    [xi.job.BST] =
    {
        modelID = 1224,
        skillList = 5049,
        petModelID =
        {
            328, -- Lizzard
            340, -- Sheep
            376, -- Funguar
            356, -- Crab
        },
        petSkillList =
        {
            174, -- Lizzard
            226, -- Sheep
            116, -- Funguar
            372, -- Crab
        },
        ability = 1433, -- Sic
        twoHour = 740, -- Familiar
        spellListID = 0,
        petID = 1,
        mods = {},
    },

    [xi.job.BRD] =
    {
        modelID = 1227,
        skillList = 5054,
        ability = 0, -- None
        twoHour = 696, -- Soul Voice
        spellListID = 6,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -25, },
        },
    },

    [xi.job.RNG] =
    {
        modelID = 1228,
        skillList = 5056,
        ability = 1434, -- Barrage
        twoHr = 413, -- Eagle Eye Shot
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.SAM] =
    {
        modelID = 1229,
        skillList = 5057,
        ability = 1436, -- Meditate
        twoHour = 730, -- Meikyo Shisui
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.NIN] =
    {
        modelID = 1232,
        skillList = 5058,
        ability = 0, -- None
        twoHour = 731, -- Mjin Gakure
        spellListID = 7,
        petID = 0,
        mods = {},
    },

    [xi.job.DRG] =
    {
        modelID = 1234,
        skillList = 5059,
        ability = 1437, -- Jump
        twoHour = 732, -- Call Wyvern
        spellListID = 0,
        petID = 2,
        mods = {},
    },

    [xi.job.SMN] =
    {
        modelID = 1235,
        skillList = 5052,
        petModelID =
        {
            793, -- Ifrit
            794, -- Titan
            795, -- Leviathan
            796, -- Garuda
            797, -- Shiva
            798, -- Ramuh
            791, -- Carbuncle
        },

        petSkillList =
        {
            38, -- Ifrit
            45, -- Titan
            40, -- Leviathan
            37, -- Garuda
            44, -- Shiva
            43, -- Ramuh
            34, -- Carbuncle
        },

        ability = 1438, -- Blood Pact
        twoHour = 734, -- Astral Flow
        spellListID = 0,
        petID = 3,
        mods =
        {
            { xi.mod.ATTP, -100, },
        },
    },

    [xi.job.BLU] =
    {
        modelID = 1396,
        skillList = 5053,
        ability = 0, -- None
        spellListID = 8, -- TODO: Mimic player's set spells
        petID = 0,
        mods = {},
    },

    [xi.job.COR] =
    {
        modelID = 1397,
        skillList = 5060,
        ability = 0, -- TODO: Add rolls here
        spellListID = 0, -- ???
        petID = 0,
        mods = {},
    },

    [xi.job.PUP] =
    {
        modelID = 1398,
        skillList = 5061,
        petModelID =
        {
            { 1983, xi.job.PLD }, -- Melee Automaton
            { 1990, xi.job.RNG }, -- Ranged Automaton
            { 1994, xi.job.BLM }, -- Magic Automaton
        },
        petSkillList =
        {
            364, -- Melee Automaton
            365, -- Ranged Automaton
            366, -- Magic Automaton
        },
        petSpellListID =
        {
            0, -- Melee Automaton
            0, -- Ranged Automaton
            2, -- Magic Automaton
        },
        ability = 1995, -- Maneuvers
        spellListID = 0,
        petID = 4,
        mods = {},
    }
}

local spawnPet = function(mob)
    local pet = GetMobByID(mob:getLocalVar('petID'))
    local job = mob:getLocalVar('job')
    mob:setMobMod(xi.mobMod.NO_MOVE, 1)
    mob:entityAnimationPacket('casm')
    mob:setLocalVar('petSpawned', 1)
    mob:setMagicCastingEnabled(false)
    mob:setAutoAttackEnabled(false)
    mob:setMobAbilityEnabled(false)

    pet:setUntargetable(false)
    pet:updateEnmity(mob:getTarget())

    -- Handle for SMN
    if job == xi.job.SMN then
        mob:setLocalVar('petModel', math.random(1, 7)) -- Random Avatar
        pet:setModelId(jobTable[job].petModelID[mob:getLocalVar('petModel')]) -- Set Model
    -- Handle for BST
    elseif job == xi.job.BST then
        mob:setLocalVar('petModel', math.random(1, 4)) -- Random Beast
        pet:setModelId(jobTable[job].petModelID[mob:getLocalVar('petModel')]) -- Set Model
    -- Handle for PUP
    elseif job == xi.job.PUP then
        mob:setLocalVar('petModel', math.random(1, 3)) -- Random Puppet
        pet:setModelId(jobTable[job].petModelID[mob:getLocalVar('petModel')][1]) -- Set Model
        pet:changeJob(jobTable[job].petModelID[mob:getLocalVar('petModel')][2]) -- Change Job
    end

    mob:timer(3000, function(mobArg)
        if mobArg:isAlive() then
            local pos = mobArg:getPos()
            mobArg:setMobMod(xi.mobMod.NO_MOVE, 0)
            mobArg:entityAnimationPacket('shsm')
            mobArg:setMagicCastingEnabled(true)
            mobArg:setAutoAttackEnabled(true)
            mobArg:setMobAbilityEnabled(true)
            mob:setLocalVar('control', 0)
            SpawnMob(pet:getID())
            pet:setPos(pos.x + math.random(-2, 2), pos.y, pos.z + math.random(-2, 2), pos.rot)
        end
    end)
end

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini.onMobSpawn', function(mob)
    mob:timer(3000, function(mobArg)
        local job = mobArg:getBattlefield():getPlayers()[1]:getMainJob()

        mobArg:setLocalVar('control', 1)
        mobArg:setLocalVar('job', job)
        mobArg:setModelId(jobTable[job].modelID)
        mobArg:changeJob(job)

        if jobTable[job].petID ~= 0 then
            mobArg:setLocalVar('petID', jobTable[job].petID + mobArg:getID())
        end

        mobArg:setMobMod(xi.mobMod.NO_STANDBACK, 1)

        -- Apply job mods (Useful for balancing)
        if jobTable[job].mods ~= nil then
            for _, mod in pairs(jobTable[job].mods) do
                mobArg:setMod(mod[1], mod[2])
            end
        end

        mob:setMobMod(xi.mobMod.SKILL_LIST, jobTable[mob:getMainJob()].skillList)
    end)
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini.onMobEngage', function(mob, target)
    local moblin = GetMobByID(mob:getID() - 2)
    moblin:updateClaim(target)
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini.onMobFight', function(mob, target)
    -- Pet summoning control
    if mob:getLocalVar('petID') > 0 then
        if
            not GetMobByID(mob:getLocalVar('petID')):isSpawned() and
            mob:getLocalVar('petSpawned') == 0
        then
            spawnPet(mob)
            mob:updateClaim(target)
        elseif
            not GetMobByID(mob:getLocalVar('petID')):isSpawned() and
            mob:getLocalVar('control') == 0
        then
            mob:setLocalVar('control', 1)
            mob:timer(30000, function(mobArg)
                mobArg:setLocalVar('petSpawned', 0)
            end)
        end
    end

    -- If Fantoccini used Chainspell or Manafont or under 30% HP
    if
        mob:hasStatusEffect(xi.effect.CHAINSPELL) or
        mob:hasStatusEffect(xi.effect.MANAFONT)
    then
        mob:setMobMod(xi.mobMod.SPELL_LIST, jobTable[mob:getMainJob()].spellListID)
        mob:setMagicCastingEnabled(true)
    else
        mob:setMagicCastingEnabled(false)
    end
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Fantoccini.onMobDeath', function(mob, player, optParams)
    if optParams.isKiller then
        local moblin = GetMobByID(mob:getID() - 2)

        moblin:showText(moblin, ID.text.NOT_HOW)
        DespawnMob(mob:getLocalVar('petID'))
        DespawnMob(moblin:getID())
    end
end)

return m
