-----------------------------------
-- Area: Spire of Holla
-- Mob: Envier
-- ENM: Playing Host
-----------------------------------
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.SPIRE_OF_MEA]
-----------------------------------
local m = Module:new('envier')

local modulePath = 'xi.zones.Spire_of_Mea.mobs.Envier'

xi.module.ensureTable('xi.zones.Spire_of_Mea.mobs.Envier')

m:addOverride(modulePath .. '.onMobEngaged', function(mob)
    mob:setLocalVar('timer', os.time() + math.random(20, 90))
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local id = mob:getID()
    local pos = mob:getPos()

    if mob:getLocalVar('timer') < os.time() and mob:getHPP() <= 75 then
        for i = 1, 3 do
            if not GetMobByID(id+i):isSpawned() then
                GetMobByID(id+i):setSpawn(pos.x, pos.y, pos.z)
                SpawnMob(id+i):updateEnmity(mob:getTarget())
                mob:setLocalVar('timer', os.time() + math.random(15,120))
                break
            end
        end
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    local id = mob:getID()

    if optParams.isKiller then
        for i = 1, 3 do
            if GetMobByID(id+i):isAlive() then
                GetMobByID(id+i):setHP(0)
            end
        end
    end
end)

return m
