-----------------------------------
-- Area: Mineshaft #2716
-- Mob: Bugboy
-- ENM: Bionic Bug
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new('bionic_bug_bugboy')

xi.module.ensureTable('xi.zones.Mine_Shaft_2716.mobs.Bugboy')

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Bugboy.onMobSpawn', function(mob)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 20)
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Bugboy.onMobWeaponSkillPrepare', function(mob, target)
    if mob:getLocalVar('naturalMobskill') == 2 then
        mob:setLocalVar('naturalMobskill', 0)
    else
        mob:setLocalVar('naturalMobskill', 1)
    end
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Bugboy.onMobWeaponSkill', function(target, mob, skill, action)
    -- Bugboy has the odd ability to use two tp moves in immediate succession, can be stunned
    mob:timer(500, function(mobArg)
        local currAction = mobArg:getCurrentAction()
        if
            mobArg:getLocalVar('naturalMobskill') == 1 and
            currAction ~= xi.action.STUN and
            currAction ~= xi.action.SLEEP and
            math.random() > mob:getHPP() / 100
        then
            mob:setLocalVar('naturalMobskill', 2)
            mobArg:useMobAbility()
        end
    end)
end)

m:addOverride('xi.zones.Mine_Shaft_2716.mobs.Bugboy.onMobFight', function(mob, target)
    local twoHours = mob:getLocalVar('twoHours') + 1

    if mob:getStatusEffect(xi.effect.MIGHTY_STRIKES) then
        -- Bugboy takes 1x magic damage during 1st Mighty Strikes, 1.5x magic damage during 2nd Mighty Strikes and 2x magic damage during 3rd Mighty Strikes.
        mob:setMod(xi.mod.UDMGMAGIC, 5000 * (mob:getLocalVar('twoHours') - 1))
    else
        mob:setMod(xi.mod.UDMGMAGIC, 0)
        if mob:getHPP() < 100 - 25 * twoHours then
            -- Bugboy's damage output increases as his hp goes down, Heavy Whisk started out doing ~200 damage at the beginning of the fight, and upwards of 700 as he nears death.
            mob:setMod(xi.mod.MAIN_DMG_RATING, 40 * twoHours)
            mob:setLocalVar('twoHours', twoHours)
            mob:useMobAbility(xi.jsa.MIGHTY_STRIKES)
            mob:setTP(3000)
        end
    end
end)

return m
