--------------------------------------------
-- Item: Yagudo Belt
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("yagudo_belt")

xi.module.ensureTable("xi.items.yagudo_belt")

m:addOverride("xi.items.yagudo_belt.onItemCheck", function(target)
    if not target:canUseMisc(xi.zoneMisc.COSTUME) then
        return xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    return 0
end)

m:addOverride("xi.items.yagudo_belt.onItemUse", function(target)
    local costumes = { 2085, 2114, 2115 }
    local randomCostume = costumes[math.random(1, #costumes)]

    target:addStatusEffect(xi.effect.COSTUME, randomCostume, 0, 3600)
end)

return m
