-----------------------------------
-- ID: 5903
-- vial_of_sea_monk_venom
-- Used for: Weakens Antaeus, removes auto-regen.
-- Used for: Weakens Arch Antaeus, removes auto-regen.
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("vial_of_sea_monk_venom")

xi.module.ensureTable("xi.items.vial_of_sea_monk_venom")

m:addOverride("xi.items.vial_of_sea_monk_venom.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Antaeus" and target:getName() ~= "Arch_Antaeus" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.vial_of_sea_monk_venom.onItemUse", function(target)
    target:addStatusEffect(xi.effect.STR_BOOST, 0, 0, 3600)
end)

return m
