-----------------------------------
-- ID: 5902
-- vial_of_cagebeast_blood
-- Used for: Weakens Apocalyptic Beast, stops jobs specials.
-- Used for: Weakens Arch Apocalyptic Beast, stops jobs specials.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("vial_of_cagebeast_blood")

xi.module.ensureTable("xi.items.vial_of_cagebeast_blood")

m:addOverride("xi.items.vial_of_cagebeast_blood.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Apocalyptic_Beast" and target:getName() ~= "Arch_Apocalyptic_Beast" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.vial_of_cagebeast_blood.onItemUse", function(target)
    target:addStatusEffect(xi.effect.INT_BOOST, 0, 0, 3600)
end)

return m
