--------------------------------------------
-- Item: Venture Ring
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_venture_ring")

xi.module.ensureTable("xi.items.venture_ring")

m:addOverride("xi.items.venture_ring.onItemCheck", function(target)
    local result = 0

    if target:hasStatusEffect(xi.effect.DEDICATION) then
        local effect = target:getStatusEffect(xi.effect.DEDICATION)
        local power  = effect:getPower()

        if power == 0 then
            result = xi.msg.basic.ITEM_UNABLE_TO_USE_2
        end
    end

    return result
end)

m:addOverride("xi.items.venture_ring.onItemUse", function(target)
    target:delStatusEffectSilent(xi.effect.DEDICATION)
    target:addStatusEffect(xi.effect.DEDICATION, 0, 0, 10800, 0, 30000)
end)

return m
