-----------------------------------
-- ID: 5905
-- undying_moiety
-- Used for: Weakens Antaeus, removes damage reduction.
-- Used for: Weakens Arch Antaeus, removes damage reduction.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("undying_moiety")

xi.module.ensureTable("xi.items.undying_moiety")

m:addOverride("xi.items.undying_moiety.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Antaeus" and target:getName() ~= "Arch_Antaeus" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.undying_moiety.onItemUse", function(target)
    target:addStatusEffect(xi.effect.VIT_BOOST, 0, 0, 3600)
end)

return m
