-----------------------------------
-- ID: 18541
-- Tjukurrpa Axe
-----------------------------------
require('modules/module_utils')
--------------------------------------------

local m = Module:new('tjukurrpa_axe')

xi.module.ensureTable('xi.items.tjukurrpa_axe')

m:addOverride('xi.items.tjukurrpa_axe.onItemEquip', function(target)
    target:addListener('TICK', 'PET_ENGAGE', function(player)
        local pet = player:getPet()
        local var = player:getLocalVar('haste_Item')

        if pet ~= nil and pet:getTarget() ~= nil then
            if player:checkDistance(player:getPet()) < 13 and var == 0 then
                player:setLocalVar('haste_Item', 1)
                player:setMod(xi.mod.HASTE_GEAR, player:getMod(xi.mod.HASTE_GEAR) + 200) -- PLAYER Haste +2%
                pet:setMod(xi.mod.HASTE_GEAR, pet:getMod(xi.mod.HASTE_GEAR) + 200) -- PET Haste +2%
            end

            if player:checkDistance(player:getPet()) > 13 and var == 1 then
                player:setLocalVar('haste_Item', 0)
                player:setMod(xi.mod.HASTE_GEAR, player:getMod(xi.mod.HASTE_GEAR) - 200) -- PLAYER Haste -2%
                pet:setMod(xi.mod.HASTE_GEAR, pet:getMod(xi.mod.HASTE_GEAR) - 200) -- PET Haste -2%
           end
        end

        if pet == nil and var > 0 then
            player:setLocalVar('haste_Item', 0)
            player:setMod(xi.mod.HASTE_GEAR, player:getMod(xi.mod.HASTE_GEAR) - 200) -- PLAYER Haste -2%
        end
     end)
end)

m:addOverride('xi.items.tjukurrpa_axe.onItemUnequip', function(target)
    target:removeListener('PET_ENGAGE')

    local pet = target:getPet()
    local var = target:getLocalVar('haste_Item')

    if pet ~= nil and var > 0 then
        target:setLocalVar("Haste_Item", 0)
        target:setMod(xi.mod.HASTE_GEAR, target:getMod(xi.mod.HASTE_GEAR) - 200) -- PLAYER Haste -2%
        pet:setMod(xi.mod.HASTE_GEAR, pet:getMod(xi.mod.HASTE_GEAR) - 200) -- PET Haste -2%
    elseif pet == nil and var > 0 then
        target:setLocalVar("Haste_Item", 0)
        target:setMod(xi.mod.HASTE_GEAR, target:getMod(xi.mod.HASTE_GEAR) - 200) -- PLAYER Haste -2%
    end
end)

return m
