-----------------------------------
-- Vajra (75): 18996
-- Thief's Knife: 16480
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_thiefs_knife_vajra")

local exclusive =
{
    { "thiefs_knife", 18996 },
    { "vajra",        16480 },
}

for _, itemInfo in pairs(exclusive) do
    local path = string.format("xi.items.%s", itemInfo[1])

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemEquip", function(player, item)
        super(player, item)

        if player:getGMLevel() > 2 then
            return 0
        elseif
            player:getEquipID(xi.slot.MAIN) == itemInfo[2]
        then
            player:unequipItem(xi.slot.SUB)
            player:messageBasic(xi.msg.basic.ITEM_UNABLE_TO_USE)
        else
            return 0
        end
    end)
end

return m
