-----------------------------------
-- Avarice: 21697
-- White Rarab Cap +1: 25679
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("item_th_stack")

local exclusive =
{
    { "avarice",            25679, xi.slot.HEAD, xi.slot.MAIN },
    { "white_rarab_cap_+1", 21697, xi.slot.MAIN, xi.slot.HEAD },
}

for _, itemInfo in pairs(exclusive) do
    local path = string.format("xi.items.%s", itemInfo[1])

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemEquip", function(target)
        if target:getGMLevel() > 2 then
            return 0
        elseif
            target:getEquipID(itemInfo[3]) == itemInfo[2] or
            (target:isCrystalWarrior() and target:getCharVar("[CW]PRESTIGE_THF") > 3)
        then
            target:unequipItem(itemInfo[4])
            target:messageBasic(xi.msg.basic.ITEM_UNABLE_TO_USE)
        else
            return 0
        end
    end)
end

return m
