--------------------------------------------
-- Teleport items
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("temp_items")

local items =
{
    -- Increase temp item effect duration when inside defined zones
    {
        name     = "dusty_scroll_of_reraise",
        effect   = xi.effect.RERAISE,
        power    = 3,
        duration = 3600,
        zones    = { xi.zone.FORT_GHELSBA, xi.zone.PALBOROUGH_MINES, xi.zone.GIDDEUS },
    },
}

for _, itemInfo in pairs(items) do
    local path = fmt("xi.items.{}", itemInfo.name)

    m:addOverride(path .. ".onItemCheck", function(target)
        return 0
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        local zoneID = target:getZoneID()

        for _, buffedZone in pairs(itemInfo.zones) do
            if zoneID == buffedZone then
                xi.itemUtils.addItemEffect(target, itemInfo.effect, itemInfo.power, itemInfo.duration)
                return 0
            end
        end

        return super(target)
    end)
end

return m
