--------------------------------------------
-- Teleport items
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("teleport_items")

local items =
{
    ["norg_earring"]       = {  -19.238,  -0.312, -63.964, 187, 252 }, -- Norg
    ["brigands_eyepatch"]  = {  -73.513,  -0.654,  30.992, 196, 252 }, -- Norg
    ["nashmau_earring"]    = {   40.658,  -6.000, -24.001, 128,  53 }, -- Nashmau
    ["kingdom_earring"]    = {  161.000,  -2.000, 161.000,  94, 230 }, -- Southern San d'Oria
    ["republic_earring"]   = { -316.408, -12.000, -94.448, 243, 235 }, -- Bastok Markets
    ["federation_earring"] = {  160.089,   1.000, -25.254, 192, 238 }, -- Windurst Waters
    ["duchy_earring"]      = {   42.927,  -5.000, -72.511, 171, 244 }, -- Upper Jeuno
    ["selbina_earring"]    = {   17.981, -14.558,  99.830,  64, 248 }, -- Selbina
    ["mhaura_earring"]     = {    0.003,  -4.000, 117.971,  65, 249 }, -- Mhaura
    ["rabao_earring"]      = {    0.152,  -1.055, -88.829, 184, 247 }, -- Rabao
}

for itemName, destination in pairs(items) do
    local path = string.format("xi.items.%s", itemName)

    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target)
        local zoneId = target:getZoneID()

        if target:hasVisitedZone(destination[5]) then
            return 0
        end

        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        target:setPos(unpack(destination))
    end)
end

return m
