require("modules/module_utils")
--------------------------------------------

local m = Module:new("wew_tartarus_platemail")

xi.module.ensureTable("xi.items.tartarus_platemail")

m:addOverride("xi.items.tartarus_platemail.onItemEquip", function(target)
    if not target:isClassicMode() then
        print(fmt("ALERT: {} is equipped with Tartarus Platemail", target:getName()))
    end
end)

m:addOverride("xi.items.tartarus_platemail.onItemCheck", function(target)
    if not target:isClassicMode() then
        target:printToPlayer("Only Wings-Era Warriors are allowed to use this item.", xi.msg.channel.SYSTEM_3)
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    if target:hasEnmity() then
        target:printToPlayer("You cannot use this item while engaged in combat.", xi.msg.channel.SYSTEM_3)
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    return 0
end)

m:addOverride("xi.items.tartarus_platemail.onItemUse", function(target)
    target:timer(5500, function(playerArg)
        target:setPos(-96, -2.149, -87, 94, 284) -- Celennia Memorial Library
    end)
end)

return m
