-----------------------------------
-- ID: 11403
-- talaria
-- Reward for WEW custom mini-expansion
-- Base quickening speed 20%
-- Extra 10% when completing the mini expansion
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("talaria")

xi.module.ensureTable("xi.items.talaria")

m:addOverride("xi.items.talaria.onItemCheck", function(target, item, param, player)
    if not target:isClassicMode() then
        target:printToPlayer("Only Wings-Era Warriors are allowed to use this item.", xi.msg.channel.SYSTEM_3)
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    if target:hasStatusEffect(xi.effect.QUICKENING) then
        return xi.msg.basic.ITEM_UNABLE_TO_USE
    end

    return 0
end)

local giveQuickening = function(target)
    local power = 20
    local typeEffect = xi.effect.QUICKENING
    if target:hasItem(xi.item.TARTARUS_PLATEMAIL) then
        power = power + 10
    end

    if
        not target:hasStatusEffect(typeEffect) and
        target:addStatusEffect(typeEffect, power, 0, 3600)
    then
        target:messageBasic(xi.msg.basic.GAINS_EFFECT_OF_STATUS, typeEffect)
    end
end

-- Give quickening on equip in town
m:addOverride("xi.items.talaria.onItemEquip", function(target)
    if
        not target:isClassicMode() or
        not target:getZone() or
        target:getZone():getTypeMask() ~= xi.zoneType.CITY
    then
        return
    end

    giveQuickening(target)
end)

m:addOverride("xi.items.talaria.onItemUse", function(target)
    local typeEffect = xi.effect.QUICKENING
    target:delStatusEffect(typeEffect)

    giveQuickening(target)

    if not target:hasStatusEffect(typeEffect) then
        target:messageBasic(xi.msg.basic.NO_EFFECT, typeEffect)
    end
end)

return m
