-----------------------------------
-- Signet Staves
-- Allow staves to be usable by any nation
-----------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("signet_staves")

local items =
{
    "kingdom_signet_staff",
    "republic_signet_staff",
    "federation_signet_staff",
}

for _, itemName in pairs(items) do
    local path = string.format("xi.items.%s", itemName)
    xi.module.ensureTable(path)

    m:addOverride(path .. ".onItemCheck", function(target, item, param, player)
        -- If target's current region is not a conquest region or not a nation city involved with conquest
        if target:getCurrentRegion() > xi.region.LIMBUS then -- Allow usage in sea as well
            return xi.msg.basic.ITEM_UNABLE_TO_USE
        end

        -- Can only use on targets within party or self
        if target:getID() ~= player:getID() then
            if
                player:getPartyLeader() == nil or
                target:getPartyLeader():getID() ~= player:getPartyLeader():getID()
            then
                return xi.msg.basic.ITEM_CANNOT_USE_ON
            end
        end

        return 0
    end)

    m:addOverride(path .. ".onItemUse", function(target)
        target:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)

        -- provide duration based on player's rank and player's nation's standing in conquest (same as xi.conquest.overseerOnEventFinish)
        local pNation  = target:getNation()
        local pRank    = target:getRank(pNation)
        local duration = (pRank + GetNationRank(pNation) + 3) * 3600
        target:addStatusEffect(xi.effect.SIGNET, 0, 0, duration)
    end)
end

return m
