--------------------------------------------
-- Item: Shell Scepter
--------------------------------------------
require("modules/module_utils")
--------------------------------------------
local m = Module:new("shell_scepter")

xi.module.ensureTable("xi.items.shell_scepter")

m:addOverride("xi.items.shell_scepter.onItemCheck", function(target)
    if not target:canUseMisc(xi.zoneMisc.COSTUME) then
        return xi.msg.basic.CANT_BE_USED_IN_AREA
    end

    return 0
end)

m:addOverride("xi.items.shell_scepter.onItemUse", function(target)
    local costumes = { 686, 997, 1090, 1249 }
    local randomCostume = costumes[math.random(1, #costumes)]

    target:addStatusEffect(xi.effect.COSTUME, randomCostume, 0, 3600)
end)

return m
