-----------------------------------
-- ID: 5900
-- shadescale_talon
-- Used for: Weakens Apocalyptic Beast, locks Chaos Blade and Petro Eyes.
-- Used for: Weakens Arch Apocalyptic Beast, reduces Chaos Blade and Petro Eyes use.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("shadescale_talon")

xi.module.ensureTable("xi.items.shadescale_talon")

m:addOverride("xi.items.shadescale_talon.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Apocalyptic_Beast" and target:getName() ~= "Arch_Apocalyptic_Beast" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.shadescale_talon.onItemUse", function(target)
    target:addStatusEffect(xi.effect.DEX_BOOST, 0, 0, 3600)
end)

return m
