-----------------------------------
-- ID: 5898
-- shadescale_skull
-- Used for: Weakens Apocalyptic Beast, locks all Breath attacks including Poison Breath, Fire Breath, and Wind Breath.
-- Used for: Weakens Arch Apocalyptic Beast, reduces Breath attacks including Poison Breath, Fire Breath, and Wind Breath.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("shadescale_skull")

xi.module.ensureTable("xi.items.shadescale_skull")

m:addOverride("xi.items.shadescale_skull.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Apocalyptic_Beast" and target:getName() ~= "Arch_Apocalyptic_Beast" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.shadescale_skull.onItemUse", function(target)
    target:addStatusEffect(xi.effect.VIT_BOOST, 0, 0, 3600)
end)

return m
