-----------------------------------
-- ID: 5901
-- shadescale_heart
-- Used for: Weakens Apocalyptic Beast, locks all "songs" including Nullsong, Lodesong, and Thornsong.
-- Used for: Weakens Arch Apocalyptic Beast, reduces Nullsong.
-----------------------------------
require("modules/module_utils")
--------------------------------------------

local m = Module:new("shadescale_heart")

xi.module.ensureTable("xi.items.shadescale_heart")

m:addOverride("xi.items.shadescale_heart.onItemCheck", function(target, item, param, player)
    local result = 0

    if target:getName() ~= "Apocalyptic_Beast" and target:getName() ~= "Arch_Apocalyptic_Beast" then
        result = xi.msg.basic.ITEM_UNABLE_TO_USE
    elseif target:checkDistance(player) > 10 then
        result = xi.msg.basic.TOO_FAR_AWAY
    end

    return result
end)

m:addOverride("xi.items.shadescale_heart.onItemUse", function(target)
    target:addStatusEffect(xi.effect.STR_BOOST, 0, 0, 3600)
end)

return m
